/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.event.DefaultEventDispatcher;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.plugins.common.AppRootInvalidException;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.DefaultCredentialRetrievers;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.InferredAuthRetrievalException;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.MainClassResolver;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class PluginConfigurationProcessor {
    private final JibContainerBuilder jibContainerBuilder;
    private final ImageReference baseImageReference;
    private final ImageReference targetImageReference;
    private final boolean isBaseImageCredentialPresent;
    private final boolean isTargetImageCredentialPresent;
    private final Containerizer containerizer;

    @Nullable
    public static List<String> computeEntrypoint(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws MainClassInferenceException, AppRootInvalidException {
        Optional<List<String>> rawEntrypoint = rawConfiguration.getEntrypoint();
        if (rawEntrypoint.isPresent() && !rawEntrypoint.get().isEmpty()) {
            if (rawConfiguration.getMainClass().isPresent() || !rawConfiguration.getJvmFlags().isEmpty()) {
                new DefaultEventDispatcher(projectProperties.getEventHandlers()).dispatch(LogEvent.warn("mainClass and jvmFlags are ignored when entrypoint is specified"));
            }
            return rawEntrypoint.get();
        }
        if (projectProperties.isWarProject()) {
            return null;
        }
        AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(rawConfiguration, projectProperties);
        String mainClass = MainClassResolver.resolveMainClass(rawConfiguration.getMainClass().orElse(null), projectProperties);
        return JavaEntrypointConstructor.makeDefaultEntrypoint(appRoot, rawConfiguration.getJvmFlags(), mainClass);
    }

    public static String getBaseImage(RawConfiguration rawConfiguration, ProjectProperties projectProperties) {
        return rawConfiguration.getFromImage().orElse(projectProperties.isWarProject() ? "gcr.io/distroless/java/jetty" : "gcr.io/distroless/java");
    }

    public static PluginConfigurationProcessor processCommonConfigurationForDockerDaemonImage(RawConfiguration rawConfiguration, ProjectProperties projectProperties, @Nullable Path dockerExecutable, @Nullable Map<String, String> dockerEnvironment, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException, MainClassInferenceException, AppRootInvalidException, InferredAuthRetrievalException, IOException {
        ImageReference targetImageReference = PluginConfigurationProcessor.getGeneratedTargetDockerTag(rawConfiguration, projectProperties, helpfulSuggestions);
        DockerDaemonImage targetImage = DockerDaemonImage.named(targetImageReference);
        if (dockerExecutable != null) {
            targetImage.setDockerExecutable(dockerExecutable);
        }
        if (dockerEnvironment != null) {
            targetImage.setDockerEnvironment(dockerEnvironment);
        }
        Containerizer containerizer = Containerizer.to(targetImage);
        return PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, projectProperties, containerizer, targetImageReference, false);
    }

    public static PluginConfigurationProcessor processCommonConfigurationForTarImage(RawConfiguration rawConfiguration, ProjectProperties projectProperties, Path tarImagePath, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException, MainClassInferenceException, AppRootInvalidException, InferredAuthRetrievalException, IOException {
        ImageReference targetImageReference = PluginConfigurationProcessor.getGeneratedTargetDockerTag(rawConfiguration, projectProperties, helpfulSuggestions);
        TarImage targetImage = TarImage.named(targetImageReference).saveTo(tarImagePath);
        Containerizer containerizer = Containerizer.to(targetImage);
        return PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, projectProperties, containerizer, targetImageReference, false);
    }

    public static PluginConfigurationProcessor processCommonConfigurationForRegistryImage(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws InferredAuthRetrievalException, InvalidImageReferenceException, MainClassInferenceException, AppRootInvalidException, IOException {
        Preconditions.checkArgument((boolean)rawConfiguration.getToImage().isPresent());
        ImageReference targetImageReference = ImageReference.parse(rawConfiguration.getToImage().get());
        RegistryImage targetImage = RegistryImage.named(targetImageReference);
        DefaultEventDispatcher eventDispatcher = new DefaultEventDispatcher(projectProperties.getEventHandlers());
        boolean isTargetImageCredentialPresent = PluginConfigurationProcessor.configureCredentialRetrievers(eventDispatcher, targetImage, targetImageReference, "jib.to.auth.username", "jib.to.auth.password", rawConfiguration.getToAuth(), "to.auth/<to><auth>", rawConfiguration::getInferredAuth, rawConfiguration.getToCredHelper().orElse(null));
        PluginConfigurationProcessor processor = PluginConfigurationProcessor.processCommonConfiguration(rawConfiguration, projectProperties, Containerizer.to(targetImage), targetImageReference, isTargetImageCredentialPresent);
        processor.getJibContainerBuilder().setFormat(rawConfiguration.getImageFormat());
        return processor;
    }

    @VisibleForTesting
    static PluginConfigurationProcessor processCommonConfiguration(RawConfiguration rawConfiguration, ProjectProperties projectProperties, Containerizer containerizer, ImageReference targetImageReference, boolean isTargetImageCredentialPresent) throws InvalidImageReferenceException, MainClassInferenceException, AppRootInvalidException, InferredAuthRetrievalException, IOException {
        JibSystemProperties.checkHttpTimeoutProperty();
        ImageReference baseImageReference = ImageReference.parse(PluginConfigurationProcessor.getBaseImage(rawConfiguration, projectProperties));
        DefaultEventDispatcher eventDispatcher = new DefaultEventDispatcher(projectProperties.getEventHandlers());
        if (JibSystemProperties.isSendCredentialsOverHttpEnabled()) {
            eventDispatcher.dispatch(LogEvent.warn("Authentication over HTTP is enabled. It is strongly recommended that you do not enable this on a public network!"));
        }
        RegistryImage baseImage = RegistryImage.named(baseImageReference);
        boolean isBaseImageCredentialPresent = PluginConfigurationProcessor.configureCredentialRetrievers(eventDispatcher, baseImage, baseImageReference, "jib.from.auth.username", "jib.from.auth.password", rawConfiguration.getFromAuth(), "from.auth/<from><auth>", rawConfiguration::getInferredAuth, rawConfiguration.getFromCredHelper().orElse(null));
        JibContainerBuilder jibContainerBuilder = Jib.from(baseImage).setLayers((List<LayerConfiguration>)projectProperties.getJavaLayerConfigurations().getLayerConfigurations()).setEntrypoint(PluginConfigurationProcessor.computeEntrypoint(rawConfiguration, projectProperties)).setProgramArguments((List<String>)rawConfiguration.getProgramArguments().orElse(null)).setEnvironment(rawConfiguration.getEnvironment()).setExposedPorts((List<Port>)ExposedPortsParser.parse(rawConfiguration.getPorts())).setLabels(rawConfiguration.getLabels()).setUser(rawConfiguration.getUser().orElse(null));
        if (rawConfiguration.getUseCurrentTimestamp()) {
            eventDispatcher.dispatch(LogEvent.warn("Setting image creation time to current time; your image may not be reproducible."));
            jibContainerBuilder.setCreationTime(Instant.now());
        }
        PluginConfigurationProcessor.configureContainerizer(containerizer, rawConfiguration, projectProperties);
        return new PluginConfigurationProcessor(jibContainerBuilder, containerizer, baseImageReference, targetImageReference, isBaseImageCredentialPresent, isTargetImageCredentialPresent);
    }

    @VisibleForTesting
    static AbsoluteUnixPath getAppRootChecked(RawConfiguration rawConfiguration, ProjectProperties projectProperties) throws AppRootInvalidException {
        String appRoot = rawConfiguration.getAppRoot();
        if (appRoot.isEmpty()) {
            appRoot = projectProperties.isWarProject() ? "/jetty/webapps/ROOT" : "/app";
        }
        try {
            return AbsoluteUnixPath.get(appRoot);
        }
        catch (IllegalArgumentException ex) {
            throw new AppRootInvalidException(appRoot, appRoot, ex);
        }
    }

    private static boolean configureCredentialRetrievers(EventDispatcher eventDispatcher, RegistryImage registryImage, ImageReference imageReference, String usernamePropertyName, String passwordPropertyName, AuthProperty knownAuth, String knownAuthSource, InferredAuthProvider inferredAuthProvider, @Nullable String credHelper) throws FileNotFoundException, InferredAuthRetrievalException {
        DefaultCredentialRetrievers defaultCredentialRetrievers = DefaultCredentialRetrievers.init(CredentialRetrieverFactory.forImage(imageReference, eventDispatcher));
        Optional<Credential> optionalToCredential = ConfigurationPropertyValidator.getImageCredential(eventDispatcher, usernamePropertyName, passwordPropertyName, knownAuth);
        boolean credentialPresent = optionalToCredential.isPresent();
        if (optionalToCredential.isPresent()) {
            defaultCredentialRetrievers.setKnownCredential(optionalToCredential.get(), knownAuthSource);
        } else {
            Optional<AuthProperty> optionalInferredAuth = inferredAuthProvider.getInferredAuth(imageReference.getRegistry());
            credentialPresent = optionalInferredAuth.isPresent();
            if (optionalInferredAuth.isPresent()) {
                AuthProperty auth = optionalInferredAuth.get();
                String username = (String)Verify.verifyNotNull((Object)auth.getUsername());
                String password = (String)Verify.verifyNotNull((Object)auth.getPassword());
                Credential credential = Credential.basic(username, password);
                defaultCredentialRetrievers.setInferredCredential(credential, auth.getPropertyDescriptor());
            }
        }
        defaultCredentialRetrievers.setCredentialHelper(credHelper);
        defaultCredentialRetrievers.asList().forEach(registryImage::addCredentialRetriever);
        return credentialPresent;
    }

    private static ImageReference getGeneratedTargetDockerTag(RawConfiguration rawConfiguration, ProjectProperties projectProperties, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException {
        return ConfigurationPropertyValidator.getGeneratedTargetDockerTag(rawConfiguration.getToImage().orElse(null), new DefaultEventDispatcher(projectProperties.getEventHandlers()), projectProperties.getName(), projectProperties.getVersion().equals("unspecified") ? "latest" : projectProperties.getVersion(), helpfulSuggestions);
    }

    private static void configureContainerizer(Containerizer containerizer, RawConfiguration rawConfiguration, ProjectProperties projectProperties) {
        containerizer.setToolName(projectProperties.getToolName()).setEventHandlers(projectProperties.getEventHandlers()).setAllowInsecureRegistries(rawConfiguration.getAllowInsecureRegistries()).setBaseImageLayersCache(Containerizer.DEFAULT_BASE_CACHE_DIRECTORY).setApplicationLayersCache(projectProperties.getCacheDirectory());
        rawConfiguration.getToTags().forEach(containerizer::withAdditionalTag);
        if (rawConfiguration.getUseOnlyProjectCache()) {
            containerizer.setBaseImageLayersCache(projectProperties.getCacheDirectory());
        }
    }

    private PluginConfigurationProcessor(JibContainerBuilder jibContainerBuilder, Containerizer containerizer, ImageReference baseImageReference, ImageReference targetImageReference, boolean isBaseImageCredentialPresent, boolean isTargetImageCredentialPresent) {
        this.jibContainerBuilder = jibContainerBuilder;
        this.containerizer = containerizer;
        this.baseImageReference = baseImageReference;
        this.targetImageReference = targetImageReference;
        this.isBaseImageCredentialPresent = isBaseImageCredentialPresent;
        this.isTargetImageCredentialPresent = isTargetImageCredentialPresent;
    }

    public JibContainerBuilder getJibContainerBuilder() {
        return this.jibContainerBuilder;
    }

    public Containerizer getContainerizer() {
        return this.containerizer;
    }

    public ImageReference getBaseImageReference() {
        return this.baseImageReference;
    }

    public ImageReference getTargetImageReference() {
        return this.targetImageReference;
    }

    public boolean isBaseImageCredentialPresent() {
        return this.isBaseImageCredentialPresent;
    }

    public boolean isTargetImageCredentialPresent() {
        return this.isTargetImageCredentialPresent;
    }

    @FunctionalInterface
    private static interface InferredAuthProvider {
        public Optional<AuthProperty> getInferredAuth(String var1) throws InferredAuthRetrievalException;
    }
}

