/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Image<T extends Layer> {
    @Nullable
    private final Instant created;
    private final ImageLayers<T> layers;
    private final ImmutableList<HistoryEntry> history;
    @Nullable
    private final ImmutableMap<String, String> environment;
    @Nullable
    private final ImmutableList<String> entrypoint;
    @Nullable
    private final ImmutableList<String> programArguments;
    @Nullable
    private final ImmutableList<Port> exposedPorts;
    @Nullable
    private final ImmutableMap<String, String> labels;
    @Nullable
    private final String workingDirectory;
    @Nullable
    private final String user;

    public static <T extends Layer> Builder<T> builder() {
        return new Builder();
    }

    private Image(@Nullable Instant created, ImageLayers<T> layers, ImmutableList<HistoryEntry> history, @Nullable ImmutableMap<String, String> environment, @Nullable ImmutableList<String> entrypoint, @Nullable ImmutableList<String> programArguments, @Nullable ImmutableList<Port> exposedPorts, @Nullable ImmutableMap<String, String> labels, @Nullable String workingDirectory, @Nullable String user) {
        this.created = created;
        this.layers = layers;
        this.history = history;
        this.environment = environment;
        this.entrypoint = entrypoint;
        this.programArguments = programArguments;
        this.exposedPorts = exposedPorts;
        this.labels = labels;
        this.workingDirectory = workingDirectory;
        this.user = user;
    }

    @Nullable
    public Instant getCreated() {
        return this.created;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Nullable
    public ImmutableList<String> getProgramArguments() {
        return this.programArguments;
    }

    @Nullable
    public ImmutableList<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    @Nullable
    public ImmutableMap<String, String> getLabels() {
        return this.labels;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public ImmutableList<T> getLayers() {
        return this.layers.getLayers();
    }

    public ImmutableList<HistoryEntry> getHistory() {
        return this.history;
    }

    public static class Builder<T extends Layer> {
        private final ImageLayers.Builder<T> imageLayersBuilder = ImageLayers.builder();
        private final ImmutableList.Builder<HistoryEntry> historyBuilder = ImmutableList.builder();
        private final Map<String, String> environmentBuilder = new HashMap<String, String>();
        private final Map<String, String> labelsBuilder = new HashMap<String, String>();
        @Nullable
        private Instant created;
        @Nullable
        private ImmutableList<String> entrypoint;
        @Nullable
        private ImmutableList<String> programArguments;
        @Nullable
        private ImmutableList<Port> exposedPorts;
        @Nullable
        private String workingDirectory;
        @Nullable
        private String user;

        public Builder<T> setCreated(Instant created) {
            this.created = created;
            return this;
        }

        public Builder<T> addEnvironment(@Nullable Map<String, String> environment) {
            if (environment != null) {
                this.environmentBuilder.putAll(environment);
            }
            return this;
        }

        public Builder<T> addEnvironmentVariable(String name, String value) {
            this.environmentBuilder.put(name, value);
            return this;
        }

        public Builder<T> setEntrypoint(@Nullable List<String> entrypoint) {
            this.entrypoint = entrypoint == null ? null : ImmutableList.copyOf(entrypoint);
            return this;
        }

        public Builder<T> setUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public Builder<T> setProgramArguments(@Nullable List<String> programArguments) {
            this.programArguments = programArguments == null ? null : ImmutableList.copyOf(programArguments);
            return this;
        }

        public Builder<T> setExposedPorts(@Nullable List<Port> exposedPorts) {
            this.exposedPorts = exposedPorts == null ? null : ImmutableList.copyOf(exposedPorts);
            return this;
        }

        public Builder<T> addLabels(@Nullable Map<String, String> labels) {
            if (labels != null) {
                this.labelsBuilder.putAll(labels);
            }
            return this;
        }

        public Builder<T> addLabel(String name, String value) {
            this.labelsBuilder.put(name, value);
            return this;
        }

        public Builder<T> setWorkingDirectory(@Nullable String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder<T> addLayer(T layer) throws LayerPropertyNotFoundException {
            this.imageLayersBuilder.add(layer);
            return this;
        }

        public Builder<T> addHistory(HistoryEntry history) {
            this.historyBuilder.add((Object)history);
            return this;
        }

        public Image<T> build() {
            return new Image(this.created, this.imageLayersBuilder.build(), this.historyBuilder.build(), ImmutableMap.copyOf(this.environmentBuilder), this.entrypoint, this.programArguments, this.exposedPorts, ImmutableMap.copyOf(this.labelsBuilder), this.workingDirectory, this.user);
        }
    }
}

