/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.Nullable;

public class JavaDockerContextGenerator {
    private static final String DEPENDENCIES_LAYER_DIRECTORY = "libs";
    private static final String SNAPSHOT_DEPENDENCIES_LAYER_DIRECTORY = "snapshot-libs";
    private static final String RESOURCES_LAYER_DIRECTORY = "resources";
    private static final String CLASSES_LAYER_DIRECTORY = "classes";
    private static final String EXTRA_FILES_LAYER_DIRECTORY = "root";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final ImmutableList<CopyDirective> copyDirectives;
    @Nullable
    private String baseImage;
    @Nullable
    private List<String> entrypoint;
    @Nullable
    private List<String> programArguments;
    @Nullable
    private Map<String, String> environment;
    @Nullable
    private String user;
    @Nullable
    private List<String> exposedPorts;
    @Nullable
    private Map<String, String> labels;

    private static void addIfNotEmpty(ImmutableList.Builder<CopyDirective> listBuilder, ImmutableList<LayerEntry> layerEntries, String directoryInContext) {
        if (layerEntries.isEmpty()) {
            return;
        }
        listBuilder.add((Object)new CopyDirective(layerEntries, directoryInContext, AbsoluteUnixPath.get("/")));
    }

    private static String mapToDockerfileString(Map<String, String> map, String command) throws JsonProcessingException {
        if (map.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(" \\\n    ", "\n" + command + " ", "");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            joiner.add(entry.getKey() + "=" + objectMapper.writeValueAsString((Object)entry.getValue()));
        }
        return joiner.toString();
    }

    public JavaDockerContextGenerator(JavaLayerConfigurations javaLayerConfigurations) {
        ImmutableList.Builder copyDirectivesBuilder = ImmutableList.builder();
        JavaDockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, javaLayerConfigurations.getDependencyLayerEntries(), DEPENDENCIES_LAYER_DIRECTORY);
        JavaDockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, javaLayerConfigurations.getSnapshotDependencyLayerEntries(), SNAPSHOT_DEPENDENCIES_LAYER_DIRECTORY);
        JavaDockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, javaLayerConfigurations.getResourceLayerEntries(), RESOURCES_LAYER_DIRECTORY);
        JavaDockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, javaLayerConfigurations.getClassLayerEntries(), CLASSES_LAYER_DIRECTORY);
        JavaDockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)copyDirectivesBuilder, javaLayerConfigurations.getExtraFilesLayerEntries(), EXTRA_FILES_LAYER_DIRECTORY);
        this.copyDirectives = copyDirectivesBuilder.build();
    }

    public JavaDockerContextGenerator setBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return this;
    }

    public JavaDockerContextGenerator setEntrypoint(@Nullable List<String> entrypoint) {
        this.entrypoint = entrypoint;
        return this;
    }

    public JavaDockerContextGenerator setUser(@Nullable String user) {
        this.user = user;
        return this;
    }

    public JavaDockerContextGenerator setProgramArguments(@Nullable List<String> programArguments) {
        this.programArguments = programArguments;
        return this;
    }

    public JavaDockerContextGenerator setEnvironment(@Nullable Map<String, String> environment) {
        this.environment = environment;
        return this;
    }

    public JavaDockerContextGenerator setExposedPorts(@Nullable List<String> exposedPorts) {
        this.exposedPorts = exposedPorts;
        return this;
    }

    public JavaDockerContextGenerator setLabels(@Nullable Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public void generate(Path targetDirectory) throws IOException {
        Preconditions.checkNotNull((Object)this.baseImage);
        try {
            Files.deleteIfExists(targetDirectory);
        }
        catch (DirectoryNotEmptyException ex) {
            MoreFiles.deleteDirectoryContents((Path)targetDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            Files.delete(targetDirectory);
        }
        Files.createDirectory(targetDirectory, new FileAttribute[0]);
        for (CopyDirective copyDirective : this.copyDirectives) {
            Path directoryInContext = targetDirectory.resolve(copyDirective.directoryInContext);
            Files.createDirectory(directoryInContext, new FileAttribute[0]);
            for (LayerEntry layerEntry : copyDirective.layerEntries) {
                String noLeadingSlash = layerEntry.getExtractionPath().toString().substring(1);
                Path destination = directoryInContext.resolve(noLeadingSlash);
                if (Files.isDirectory(layerEntry.getSourceFile(), new LinkOption[0])) {
                    Files.createDirectories(destination, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                Files.copy(layerEntry.getSourceFile(), destination, new CopyOption[0]);
            }
        }
        Files.write(targetDirectory.resolve("Dockerfile"), this.makeDockerfile().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    String makeDockerfile() throws JsonProcessingException {
        StringBuilder dockerfile = new StringBuilder();
        dockerfile.append("FROM ").append((String)Preconditions.checkNotNull((Object)this.baseImage)).append("\n");
        for (CopyDirective copyDirective : this.copyDirectives) {
            boolean hasTrailingSlash = copyDirective.extractionPath.toString().endsWith("/");
            dockerfile.append("\nCOPY ").append(copyDirective.directoryInContext).append(" ").append(copyDirective.extractionPath).append(hasTrailingSlash ? "" : "/");
        }
        dockerfile.append("\n");
        if (this.exposedPorts != null) {
            for (String port : this.exposedPorts) {
                dockerfile.append("\nEXPOSE ").append(port);
            }
        }
        if (this.environment != null) {
            dockerfile.append(JavaDockerContextGenerator.mapToDockerfileString(this.environment, "ENV"));
        }
        if (this.labels != null) {
            dockerfile.append(JavaDockerContextGenerator.mapToDockerfileString(this.labels, "LABEL"));
        }
        if (this.entrypoint != null) {
            dockerfile.append("\nENTRYPOINT ").append(objectMapper.writeValueAsString(this.entrypoint));
        }
        if (this.programArguments != null) {
            dockerfile.append("\nCMD ").append(objectMapper.writeValueAsString(this.programArguments));
        }
        if (this.user != null) {
            dockerfile.append("\nUSER ").append(this.user);
        }
        return dockerfile.toString();
    }

    private static class CopyDirective {
        private final ImmutableList<LayerEntry> layerEntries;
        private final String directoryInContext;
        private final AbsoluteUnixPath extractionPath;

        private CopyDirective(ImmutableList<LayerEntry> layerEntries, String directoryInContext, AbsoluteUnixPath extractionPath) {
            this.layerEntries = layerEntries;
            this.directoryInContext = directoryInContext;
            this.extractionPath = extractionPath;
        }
    }
}

