/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event.events;

import com.google.cloud.tools.jib.event.JibEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;

public class LogEvent
implements JibEvent {
    private final Level level;
    private final String message;

    public static LogEvent error(String message) {
        return new LogEvent(Level.ERROR, message);
    }

    public static LogEvent lifecycle(String message) {
        return new LogEvent(Level.LIFECYCLE, message);
    }

    public static LogEvent warn(String message) {
        return new LogEvent(Level.WARN, message);
    }

    public static LogEvent info(String message) {
        return new LogEvent(Level.INFO, message);
    }

    public static LogEvent debug(String message) {
        return new LogEvent(Level.DEBUG, message);
    }

    private LogEvent(Level level, String message) {
        this.level = level;
        this.message = message;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    @VisibleForTesting
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LogEvent)) {
            return false;
        }
        LogEvent otherLogEvent = (LogEvent)other;
        return this.level == otherLogEvent.level && this.message.equals(otherLogEvent.message);
    }

    @VisibleForTesting
    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.message});
    }

    public static enum Level {
        ERROR,
        WARN,
        LIFECYCLE,
        INFO,
        DEBUG;

    }
}

