/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.AsyncSteps;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.FinalizingStep;
import com.google.cloud.tools.jib.builder.steps.LoadDockerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushImageStep;
import com.google.cloud.tools.jib.builder.steps.PushLayersStep;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.builder.steps.WriteTarFileStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class StepsRunner {
    private final ListeningExecutorService listeningExecutorService;
    private final BuildConfiguration buildConfiguration;
    @Nullable
    private RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep;
    @Nullable
    private AuthenticatePushStep authenticatePushStep;
    @Nullable
    private PullBaseImageStep pullBaseImageStep;
    @Nullable
    private PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    @Nullable
    private ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    @Nullable
    private PushLayersStep pushBaseImageLayersStep;
    @Nullable
    private PushLayersStep pushApplicationLayersStep;
    @Nullable
    private BuildImageStep buildImageStep;
    @Nullable
    private PushContainerConfigurationStep pushContainerConfigurationStep;
    @Nullable
    private PushImageStep pushImageStep;
    @Nullable
    private LoadDockerStep loadDockerStep;
    @Nullable
    private WriteTarFileStep writeTarFileStep;

    public StepsRunner(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
        Object executorService = JibSystemProperties.isSerializedExecutionEnabled() ? MoreExecutors.newDirectExecutorService() : buildConfiguration.getExecutorService();
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
    }

    public StepsRunner runRetrieveTargetRegistryCredentialsStep() {
        this.retrieveTargetRegistryCredentialsStep = RetrieveRegistryCredentialsStep.forTargetImage(this.listeningExecutorService, this.buildConfiguration);
        return this;
    }

    public StepsRunner runAuthenticatePushStep() {
        this.authenticatePushStep = new AuthenticatePushStep(this.listeningExecutorService, this.buildConfiguration, (RetrieveRegistryCredentialsStep)Preconditions.checkNotNull((Object)this.retrieveTargetRegistryCredentialsStep));
        return this;
    }

    public StepsRunner runPullBaseImageStep() {
        this.pullBaseImageStep = new PullBaseImageStep(this.listeningExecutorService, this.buildConfiguration);
        return this;
    }

    public StepsRunner runPullAndCacheBaseImageLayersStep() {
        this.pullAndCacheBaseImageLayersStep = new PullAndCacheBaseImageLayersStep(this.listeningExecutorService, this.buildConfiguration, (PullBaseImageStep)Preconditions.checkNotNull((Object)this.pullBaseImageStep));
        return this;
    }

    public StepsRunner runPushBaseImageLayersStep() {
        this.pushBaseImageLayersStep = new PushLayersStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (AsyncStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep));
        return this;
    }

    public StepsRunner runBuildAndCacheApplicationLayerSteps() {
        this.buildAndCacheApplicationLayerSteps = BuildAndCacheApplicationLayerStep.makeList(this.listeningExecutorService, this.buildConfiguration);
        return this;
    }

    public StepsRunner runBuildImageStep() {
        this.buildImageStep = new BuildImageStep(this.listeningExecutorService, this.buildConfiguration, (PullBaseImageStep)Preconditions.checkNotNull((Object)this.pullBaseImageStep), (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)));
        return this;
    }

    public StepsRunner runPushContainerConfigurationStep() {
        this.pushContainerConfigurationStep = new PushContainerConfigurationStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public StepsRunner runPushApplicationLayersStep() {
        this.pushApplicationLayersStep = new PushLayersStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), AsyncSteps.immediate((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)));
        return this;
    }

    public StepsRunner runFinalizingPushStep() {
        new FinalizingStep(this.listeningExecutorService, this.buildConfiguration, Arrays.asList((AsyncStep)Preconditions.checkNotNull((Object)this.pushBaseImageLayersStep), (AsyncStep)Preconditions.checkNotNull((Object)this.pushApplicationLayersStep)), Collections.emptyList());
        return this;
    }

    public StepsRunner runFinalizingBuildStep() {
        new FinalizingStep(this.listeningExecutorService, this.buildConfiguration, Collections.singletonList((AsyncStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep)), (List)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps));
        return this;
    }

    public StepsRunner runPushImageStep() {
        this.pushImageStep = new PushImageStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (PushLayersStep)Preconditions.checkNotNull((Object)this.pushBaseImageLayersStep), (PushLayersStep)Preconditions.checkNotNull((Object)this.pushApplicationLayersStep), (PushContainerConfigurationStep)Preconditions.checkNotNull((Object)this.pushContainerConfigurationStep), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public StepsRunner runLoadDockerStep(DockerClient dockerClient) {
        this.loadDockerStep = new LoadDockerStep(this.listeningExecutorService, dockerClient, this.buildConfiguration, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public StepsRunner runWriteTarFileStep(Path outputPath) {
        this.writeTarFileStep = new WriteTarFileStep(this.listeningExecutorService, outputPath, this.buildConfiguration, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public BuildResult waitOnPushImageStep() throws ExecutionException, InterruptedException {
        return (BuildResult)((PushImageStep)Preconditions.checkNotNull((Object)this.pushImageStep)).getFuture().get();
    }

    public BuildResult waitOnLoadDockerStep() throws ExecutionException, InterruptedException {
        return (BuildResult)((LoadDockerStep)Preconditions.checkNotNull((Object)this.loadDockerStep)).getFuture().get();
    }

    public BuildResult waitOnWriteTarFileStep() throws ExecutionException, InterruptedException {
        return (BuildResult)((WriteTarFileStep)Preconditions.checkNotNull((Object)this.writeTarFileStep)).getFuture().get();
    }
}

