/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.artifactregistry.gradle.plugin;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.artifactregistry.auth.CredentialProvider;
import com.google.cloud.artifactregistry.auth.DefaultCredentialProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenArtifactRepository;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.tasks.Input;
import org.gradle.internal.authentication.DefaultBasicAuthentication;
import org.gradle.plugin.management.PluginManagementSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactRegistryGradlePlugin
implements Plugin<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ArtifactRegistryGradlePlugin.class);
    private final CredentialProvider credentialProvider = new DefaultCredentialProvider();

    public void apply(Object o) {
        ArtifactRegistryPasswordCredentials crd;
        try {
            GoogleCredentials credentials = (GoogleCredentials)this.credentialProvider.getCredential();
            credentials.refreshIfExpired();
            AccessToken accessToken = credentials.getAccessToken();
            String token = accessToken.getTokenValue();
            crd = new ArtifactRegistryPasswordCredentials("oauth2accesstoken", token);
        }
        catch (IOException e) {
            logger.info("Failed to get access token from gcloud or Application Default Credentials", (Throwable)e);
            return;
        }
        if (o instanceof Project) {
            this.applyProject((Project)o, crd);
        } else if (o instanceof Gradle) {
            this.applyGradle((Gradle)o, crd);
        } else if (o instanceof Settings) {
            this.applySettings((Settings)o, crd);
        }
    }

    private void applyGradle(Gradle gradle, ArtifactRegistryPasswordCredentials crd) {
        gradle.settingsEvaluated(s -> this.modifySettings((Settings)s, crd));
        gradle.projectsLoaded(g -> g.allprojects(p -> this.modifyProjectBuildscript((Project)p, crd)));
        gradle.projectsEvaluated(g -> g.allprojects(p -> this.modifyProject((Project)p, crd)));
    }

    private void applySettings(Settings settings, ArtifactRegistryPasswordCredentials crd) {
        this.applyGradle(settings.getGradle(), crd);
    }

    private void applyProject(Project project, ArtifactRegistryPasswordCredentials crd) {
        project.afterEvaluate(p -> this.modifyProject((Project)p, crd));
    }

    private void modifyProject(Project p, ArtifactRegistryPasswordCredentials crd) {
        p.getRepositories().forEach(r -> this.configureArtifactRegistryRepository((ArtifactRepository)r, crd));
        PublishingExtension publishingExtension = (PublishingExtension)p.getExtensions().findByType(PublishingExtension.class);
        if (publishingExtension != null) {
            publishingExtension.getRepositories().forEach(r -> this.configureArtifactRegistryRepository((ArtifactRepository)r, crd));
        }
    }

    private void modifyProjectBuildscript(Project p, ArtifactRegistryPasswordCredentials crd) {
        ScriptHandler buildscript = p.getBuildscript();
        if (buildscript != null) {
            buildscript.getRepositories().whenObjectAdded(r -> this.configureArtifactRegistryRepository((ArtifactRepository)r, crd));
        }
    }

    private void modifySettings(Settings s, ArtifactRegistryPasswordCredentials crd) {
        PluginManagementSpec pluginManagement = s.getPluginManagement();
        if (pluginManagement != null) {
            pluginManagement.getRepositories().forEach(r -> this.configureArtifactRegistryRepository((ArtifactRepository)r, crd));
        }
    }

    private void configureArtifactRegistryRepository(ArtifactRepository repo, ArtifactRegistryPasswordCredentials crd) throws ProjectConfigurationException, UncheckedIOException {
        if (!(repo instanceof DefaultMavenArtifactRepository)) {
            return;
        }
        DefaultMavenArtifactRepository cbaRepo = (DefaultMavenArtifactRepository)repo;
        URI u = cbaRepo.getUrl();
        if (u != null && u.getScheme() != null && u.getScheme().equals("artifactregistry")) {
            try {
                cbaRepo.setUrl(new URI("https", u.getHost(), u.getPath(), u.getFragment()));
            }
            catch (URISyntaxException e) {
                throw new ProjectConfigurationException(String.format("Invalid repository URL %s", u.toString()), (Throwable)e);
            }
            if (ArtifactRegistryGradlePlugin.shouldStoreCredentials(cbaRepo)) {
                cbaRepo.setConfiguredCredentials((Credentials)crd);
                cbaRepo.authentication(authenticationContainer -> authenticationContainer.add((Object)new DefaultBasicAuthentication("basic")));
            }
        }
    }

    private static boolean shouldStoreCredentials(DefaultMavenArtifactRepository repo) {
        try {
            Method getConfiguredCredentials = DefaultMavenArtifactRepository.class.getMethod("getConfiguredCredentials", new Class[0]);
            if (getConfiguredCredentials.getReturnType().equals(Credentials.class)) {
                Credentials existingCredentials = (Credentials)getConfiguredCredentials.invoke((Object)repo, new Object[0]);
                return existingCredentials == null;
            }
            if (getConfiguredCredentials.getReturnType().equals(Property.class)) {
                Property existingCredentials = (Property)getConfiguredCredentials.invoke((Object)repo, new Object[0]);
                return !existingCredentials.isPresent();
            }
            logger.warn("Error determining Gradle credentials API; expect authentication errors");
            return false;
        }
        catch (ReflectiveOperationException e) {
            logger.warn("Error determining Gradle credentials API; expect authentication errors", (Throwable)e);
            return false;
        }
    }

    static class ArtifactRegistryPasswordCredentials
    implements PasswordCredentials {
        private String username;
        private String password;

        ArtifactRegistryPasswordCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Input
        public String getUsername() {
            return this.username;
        }

        @Input
        public String getPassword() {
            return this.password;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

