/*
 * Decompiled with CFR 0.152.
 */
package com.github.gregwhitaker.gitignore.tasks;

import java.io.IOException;
import java.util.Arrays;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.validator.routines.UrlValidator;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class ListGitIgnoreFacetsTask
extends DefaultTask {
    private static final String GITIGNORE_BASE_URL = "https://www.toptal.com/developers/gitignore/api/";

    public ListGitIgnoreFacetsTask() {
        this.setGroup("gitignore");
        this.setDescription("Lists all of the supported project facets.");
    }

    @TaskAction
    public void run() {
        String contents = this.getUrl("https://www.toptal.com/developers/gitignore/api/list");
        if (contents.length() > 0) {
            String[] facets = contents.split(",");
            Arrays.stream(facets).forEach(System.out::println);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUrl(String url) {
        if (!UrlValidator.getInstance().isValid(url)) {
            throw new GradleException(String.format("Invalid url. [url: '%s']", url));
        }
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().get().url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            if (response.code() == 404) {
                throw new GradleException(String.format("Resource not found. [url: '%s']", new Object[0]));
            }
            throw new GradleException(String.format("Error occurred while retrieving data from url. [code: '%s', url: '%s']", response.code(), url));
        }
        catch (IOException e) {
            throw new GradleException(String.format("Error occurred while retrieving data from url. [url: '%s']", url));
        }
    }
}

