/*
 * Decompiled with CFR 0.152.
 */
package com.github.gregwhitaker.gitignore.facets;

import com.github.gregwhitaker.gitignore.facets.FacetDetector;
import java.util.Locale;
import java.util.Set;

public class OperatingSystemFacetDetector
implements FacetDetector {
    private static final String WINDOWS = "windows";
    private static final String MAC_OS = "macos";
    private static final String MAC_OSX = "osx";
    private static final String LINUX = "linux";

    @Override
    public void facets(Set<String> facets) {
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin")) {
            facets.add(MAC_OS);
            facets.add(MAC_OSX);
        } else if (os.contains("win")) {
            facets.add(WINDOWS);
        } else if (os.contains("nux")) {
            facets.add(LINUX);
        }
    }
}

