/*
 * Decompiled with CFR 0.152.
 */
package com.github.gregwhitaker.gitignore;

import com.github.gregwhitaker.gitignore.tasks.CreateGitIgnoreTask;
import com.github.gregwhitaker.gitignore.tasks.DeleteGitIgnoreTask;
import com.github.gregwhitaker.gitignore.tasks.ListGitIgnoreFacetsTask;
import com.github.gregwhitaker.gitignore.tasks.PrintGitIgnoreTask;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskCollection;

public class GitIgnoreModule {
    public static final String CREATE_GITIGNORE_TASK_NAME = "createGitIgnore";
    public static final String DELETE_GITIGNORE_TASK_NAME = "deleteGitIgnore";
    public static final String PRINT_GITIGNORE_TASK_NAME = "printGitIgnore";
    public static final String LIST_GITIGNORE_FACETS_TASK_NAME = "listGitIgnoreFacets";

    public static void load(Project project) {
        project.getLogger().info("Loading Gitignore Module");
        HashMap<String, Class> tasks = new HashMap<String, Class>();
        tasks.put(CREATE_GITIGNORE_TASK_NAME, CreateGitIgnoreTask.class);
        tasks.put(DELETE_GITIGNORE_TASK_NAME, DeleteGitIgnoreTask.class);
        tasks.put(PRINT_GITIGNORE_TASK_NAME, PrintGitIgnoreTask.class);
        tasks.put(LIST_GITIGNORE_FACETS_TASK_NAME, ListGitIgnoreFacetsTask.class);
        tasks.forEach((name, clazz) -> project.getTasks().create(name, clazz));
        GitIgnoreModule.autoCreateGitIgnoreOnApply(project);
    }

    private static void autoCreateGitIgnoreOnApply(Project project) {
        File file = Paths.get(project.getProjectDir().getAbsolutePath(), ".gitignore").toFile();
        if (!file.exists()) {
            TaskCollection createGitIgnoreTasks = project.getTasks().withType(CreateGitIgnoreTask.class);
            CreateGitIgnoreTask task = (CreateGitIgnoreTask)createGitIgnoreTasks.getByName(CREATE_GITIGNORE_TASK_NAME);
            task.run();
        }
    }
}

