/*
 * Decompiled with CFR 0.152.
 */
package com.github.edeandrea.xjcplugin.plugin;

import com.github.edeandrea.xjcplugin.domain.Schema;
import com.github.edeandrea.xjcplugin.domain.XjcExtension;
import com.github.edeandrea.xjcplugin.plugin.XjcPlugin;
import com.github.edeandrea.xjcplugin.type.Xjc;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/github/edeandrea/xjcplugin/plugin/XjcPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "createTasksFromSchemas", "getSchemaFiles", "Lorg/gradle/api/file/FileCollection;", "schemaRootDir", "", "schema", "Lcom/github/edeandrea/xjcplugin/domain/Schema;", "useSchemaFile", "", "getTaskName", "linkTaskToPreCompile", "sourceSetName", "xjcTask", "Lcom/github/edeandrea/xjcplugin/type/Xjc;", "language", "linkTasksToPreCompile", "Companion", "xjc-generation-gradle-plugin"})
public final class XjcPlugin
implements Plugin<Project> {
    private static final Logger log;
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getPluginManager().apply("java");
        project.getConfigurations().maybeCreate("xjc");
        project.getExtensions().create("xjcGeneration", XjcExtension.class, new Object[]{project});
        project.task(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"Code Generation"), TuplesKt.to((Object)"description", (Object)"Run all XJC tasks"), TuplesKt.to((Object)"dependsOn", (Object)project.getTasks().withType(Xjc.class))}), "xjcGeneration");
        project.afterEvaluate((Action)new Action<Project>(this, project){
            final /* synthetic */ XjcPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                XjcPlugin.access$createTasksFromSchemas(this.this$0, this.$project);
            }
            {
                this.this$0 = xjcPlugin;
                this.$project = project;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void createTasksFromSchemas(Project project) {
        XjcExtension xjcExtension = (XjcExtension)project.getExtensions().getByType(XjcExtension.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        Iterable $this$forEach$iv = (Iterable)xjcExtension.getSchemas();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Xjc xjcTask;
            boolean schemaDirBlank;
            Schema schema = (Schema)element$iv;
            boolean bl = false;
            CharSequence charSequence = schema.getSchemaFile();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean schemaFileBlank = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
            CharSequence charSequence2 = schema.getSchemaDir();
            bl3 = false;
            boolean bl4 = false;
            boolean bl5 = schemaDirBlank = charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2);
            if (schemaFileBlank && schemaDirBlank) {
                throw (Throwable)new GradleException("Schema '" + schema.getName() + "' ==> Either property 'schemaFile' or 'schemaDir' needs to be set (but not both)");
            }
            if (!schemaFileBlank && !schemaDirBlank) {
                throw (Throwable)new GradleException("Schema '" + schema.getName() + "' ==> Both properties 'schemaFile' and 'schemaDir' are set. Only one can be set.");
            }
            Schema schema2 = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"schema");
            String taskName = this.getTaskName(schema2);
            String xjcTaskClassName = xjcExtension.getXjcTaskClassName();
            String string = schema.getSourceSet();
            if (string == null) {
                string = xjcExtension.getDefaultSourceSet();
            }
            String sourceSetName = string;
            SourceSet sourceSet = (SourceSet)sourceSets.getByName(sourceSetName);
            String string2 = schema.getSchemaRootDir();
            if (string2 == null) {
                string2 = project.getProjectDir() + "/src/" + sourceSetName + "/schemas/xjc";
            }
            String schemaRootDir = string2;
            boolean onePassMode = schema.getOnePassMode();
            FileCollection schemaFiles = this.getSchemaFiles(project, schemaRootDir, schema, schemaDirBlank);
            String string3 = schema.getGeneratedOutputRootDir();
            if (string3 == null) {
                string3 = project.getBuildDir() + "/generated-sources/" + sourceSetName + "/xjc";
            }
            String generatedSourcesDir = string3;
            File bindingFile = schema.getBindingFile() != null ? project.file((Object)(project.getProjectDir() + '/' + schema.getBindingFile())) : xjcExtension.getDefaultBindingFile();
            String string4 = schema.getDescription();
            if (string4 == null) {
                string4 = "Generate sources for the schema " + schema.getName();
            }
            String taskDesc = string4;
            Map additionalXjcOptions = MapsKt.plus(xjcExtension.getDefaultAdditionalXjcOptions(), schema.getAdditionalXjcOptions());
            Map additionalXjcCommandLineArgs = MapsKt.plus(xjcExtension.getDefaultAdditionalXjcCommandLineArgs(), schema.getAdditionalXjcCommandLineArgs());
            Logger logger = log;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
            if (logger.isInfoEnabled()) {
                void $this$forEach$iv2;
                void $this$mapTo$iv$iv;
                log.info("------------------------------------------");
                log.info("taskName = " + taskName);
                log.info("antTaskClassName = " + xjcTaskClassName);
                log.info("sourceSetName = " + sourceSetName);
                log.info("schemaRootDir = " + schemaRootDir);
                log.info("onePassMode = " + onePassMode);
                log.info("generatedSourcesDir = " + generatedSourcesDir);
                log.info("bindingFile = " + bindingFile);
                log.info("taskDesc = " + taskDesc);
                log.info("additionalXjcOptions = " + additionalXjcOptions);
                log.info("additionalXjcCommandLineArgs = " + additionalXjcCommandLineArgs);
                log.info("schemaFiles =");
                Set set = schemaFiles.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"schemaFiles.files");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p1;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl6 = false;
                    String string5 = p1.getPath();
                    collection.add(string5);
                }
                $this$map$iv = (List)destination$iv$iv;
                Logger logger2 = log;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String p1 = (String)element$iv2;
                    boolean bl7 = false;
                    logger2.info(p1);
                }
                log.info("------------------------------------------");
            }
            SourceSet sourceSet2 = sourceSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet2, (String)"sourceSet");
            sourceSet2.getJava().srcDir((Object)generatedSourcesDir);
            Xjc xjc = xjcTask = (Xjc)project.getTasks().create(taskName, Xjc.class, (Action)new Action<Xjc>(taskDesc, xjcTaskClassName, onePassMode, schemaFiles, schemaRootDir, schema, sourceSet, bindingFile, generatedSourcesDir, additionalXjcOptions, additionalXjcCommandLineArgs, this, xjcExtension, sourceSets, project){
                final /* synthetic */ String $taskDesc;
                final /* synthetic */ String $xjcTaskClassName;
                final /* synthetic */ boolean $onePassMode;
                final /* synthetic */ FileCollection $schemaFiles;
                final /* synthetic */ String $schemaRootDir;
                final /* synthetic */ Schema $schema;
                final /* synthetic */ SourceSet $sourceSet;
                final /* synthetic */ File $bindingFile;
                final /* synthetic */ String $generatedSourcesDir;
                final /* synthetic */ Map $additionalXjcOptions;
                final /* synthetic */ Map $additionalXjcCommandLineArgs;
                final /* synthetic */ XjcPlugin this$0;
                final /* synthetic */ XjcExtension $xjcExtension$inlined;
                final /* synthetic */ SourceSetContainer $sourceSets$inlined;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$taskDesc = string;
                    this.$xjcTaskClassName = string2;
                    this.$onePassMode = bl;
                    this.$schemaFiles = fileCollection;
                    this.$schemaRootDir = string3;
                    this.$schema = schema;
                    this.$sourceSet = sourceSet;
                    this.$bindingFile = file;
                    this.$generatedSourcesDir = string4;
                    this.$additionalXjcOptions = map;
                    this.$additionalXjcCommandLineArgs = map2;
                    this.this$0 = xjcPlugin;
                    this.$xjcExtension$inlined = xjcExtension;
                    this.$sourceSets$inlined = sourceSetContainer;
                    this.$project$inlined = project;
                }

                public final void execute(Xjc it) {
                    Xjc xjc = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)xjc), (String)"it");
                    xjc.setDescription(this.$taskDesc);
                    it.setXjcTaskClassName(this.$xjcTaskClassName);
                    it.setOnePassMode(this.$onePassMode);
                    it.setSchemaFiles(this.$schemaFiles);
                    File file = this.$project$inlined.file((Object)this.$schemaRootDir);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(schemaRootDir)");
                    it.setSchemaRootDir(file);
                    it.setJavaPackageName(this.$schema.getJavaPackageName());
                    SourceSet sourceSet = this.$sourceSet;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet, (String)"sourceSet");
                    it.setSourceSet(sourceSet);
                    it.setBindingFile(this.$bindingFile);
                    File file2 = this.$project$inlined.file((Object)this.$generatedSourcesDir);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.file(generatedSourcesDir)");
                    it.setSchemaGenDir(file2);
                    it.setAdditionalXjcOptions(this.$additionalXjcOptions);
                    it.setAdditionalXjcCommandLineArgs(this.$additionalXjcCommandLineArgs);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)xjc), (String)"xjcTask");
            this.linkTasksToPreCompile(sourceSetName, project, xjc);
        }
    }

    private final void linkTaskToPreCompile(String sourceSetName, Project project, Xjc xjcTask, String language) {
        String sourceSetNameTaskName = Intrinsics.areEqual((Object)sourceSetName, (Object)"main") ? "compile" + language : "compile" + StringsKt.capitalize((String)sourceSetName) + language;
        project.getTasks().getByName(sourceSetNameTaskName).dependsOn(new Object[]{xjcTask});
    }

    private final void linkTasksToPreCompile(String sourceSetName, Project project, Xjc xjcTask) {
        project.getPluginManager().withPlugin("java", (Action)new Action<AppliedPlugin>(this, sourceSetName, project, xjcTask){
            final /* synthetic */ XjcPlugin this$0;
            final /* synthetic */ String $sourceSetName;
            final /* synthetic */ Project $project;
            final /* synthetic */ Xjc $xjcTask;

            public final void execute(AppliedPlugin it) {
                XjcPlugin.access$linkTaskToPreCompile(this.this$0, this.$sourceSetName, this.$project, this.$xjcTask, "Java");
            }
            {
                this.this$0 = xjcPlugin;
                this.$sourceSetName = string;
                this.$project = project;
                this.$xjcTask = xjc;
            }
        });
        project.getPluginManager().withPlugin("groovy", (Action)new Action<AppliedPlugin>(this, sourceSetName, project, xjcTask){
            final /* synthetic */ XjcPlugin this$0;
            final /* synthetic */ String $sourceSetName;
            final /* synthetic */ Project $project;
            final /* synthetic */ Xjc $xjcTask;

            public final void execute(AppliedPlugin it) {
                XjcPlugin.access$linkTaskToPreCompile(this.this$0, this.$sourceSetName, this.$project, this.$xjcTask, "Groovy");
            }
            {
                this.this$0 = xjcPlugin;
                this.$sourceSetName = string;
                this.$project = project;
                this.$xjcTask = xjc;
            }
        });
        project.getPluginManager().withPlugin("scala", (Action)new Action<AppliedPlugin>(this, sourceSetName, project, xjcTask){
            final /* synthetic */ XjcPlugin this$0;
            final /* synthetic */ String $sourceSetName;
            final /* synthetic */ Project $project;
            final /* synthetic */ Xjc $xjcTask;

            public final void execute(AppliedPlugin it) {
                XjcPlugin.access$linkTaskToPreCompile(this.this$0, this.$sourceSetName, this.$project, this.$xjcTask, "Scala");
            }
            {
                this.this$0 = xjcPlugin;
                this.$sourceSetName = string;
                this.$project = project;
                this.$xjcTask = xjc;
            }
        });
        project.getPluginManager().withPlugin("kotlin", (Action)new Action<AppliedPlugin>(this, sourceSetName, project, xjcTask){
            final /* synthetic */ XjcPlugin this$0;
            final /* synthetic */ String $sourceSetName;
            final /* synthetic */ Project $project;
            final /* synthetic */ Xjc $xjcTask;

            public final void execute(AppliedPlugin it) {
                XjcPlugin.access$linkTaskToPreCompile(this.this$0, this.$sourceSetName, this.$project, this.$xjcTask, "Kotlin");
            }
            {
                this.this$0 = xjcPlugin;
                this.$sourceSetName = string;
                this.$project = project;
                this.$xjcTask = xjc;
            }
        });
    }

    private final FileCollection getSchemaFiles(Project project, String schemaRootDir, Schema schema, boolean useSchemaFile) {
        FileCollection fileCollection;
        if (useSchemaFile) {
            ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{schemaRootDir + '/' + schema.getSchemaFile()});
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(\"$schemaRo\u2026ir/${schema.schemaFile}\")");
            fileCollection = (FileCollection)configurableFileCollection;
        } else {
            Object[] objectArray = new Object[1];
            File file = project.file((Object)(schemaRootDir + '/' + schema.getSchemaDir()));
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(\"$schemaRootDir/${schema.schemaDir}\")");
            objectArray[0] = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file)), (Function1)getSchemaFiles.1.INSTANCE));
            ConfigurableFileCollection configurableFileCollection = project.files(objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(project.fi\u2026r { it.isFile }.toList())");
            fileCollection = (FileCollection)configurableFileCollection;
        }
        return fileCollection;
    }

    private final String getTaskName(Schema schema) {
        String schemaGenTaskNameBeginning = "schemaGen_";
        CharSequence charSequence = schema.getTaskName();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            String schemaStr;
            String javaPackageName = schema.getJavaPackageName();
            CharSequence charSequence2 = javaPackageName;
            bl2 = false;
            if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                String replacedPackageName = StringsKt.replace$default((String)javaPackageName, (String)".", (String)"-", (boolean)false, (int)4, null);
                return schemaGenTaskNameBeginning + replacedPackageName;
            }
            String string = schema.getSchemaFile();
            if (string == null) {
                string = schema.getSchemaDir();
            }
            String string2 = schemaStr = string;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String replacedSchemaFile = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)" ", (String)"-", (boolean)false, (int)4, null), (String)"/", (String)"-", (boolean)false, (int)4, null);
            return schemaGenTaskNameBeginning + replacedSchemaFile;
        }
        String string = schema.getTaskName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        log = Logging.getLogger(XjcPlugin.class);
    }

    public static final /* synthetic */ void access$createTasksFromSchemas(XjcPlugin $this, Project project) {
        $this.createTasksFromSchemas(project);
    }

    public static final /* synthetic */ void access$linkTaskToPreCompile(XjcPlugin $this, String sourceSetName, Project project, Xjc xjcTask, String language) {
        $this.linkTaskToPreCompile(sourceSetName, project, xjcTask, language);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/edeandrea/xjcplugin/plugin/XjcPlugin$Companion;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/gradle/api/logging/Logger;", "xjc-generation-gradle-plugin"})
    public static final class Companion {
        public final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

