/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.vcs;

import com.github.blindpirate.gogradle.build.SubprocessReader;
import com.github.blindpirate.gogradle.core.exceptions.BuildException;
import com.github.blindpirate.gogradle.util.ProcessUtils;
import com.github.blindpirate.gogradle.vcs.GitMercurialCommit;
import com.github.blindpirate.gogradle.vcs.VcsAccessor;
import com.github.blindpirate.gogradle.vcs.git.GitClientLineConsumer;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;

public abstract class GitMercurialAccessor
implements VcsAccessor {
    protected final ProcessUtils processUtils;

    public GitMercurialAccessor(ProcessUtils processUtils) {
        this.processUtils = processUtils;
    }

    public abstract void checkout(File var1, String var2);

    public abstract String getDefaultBranch(File var1);

    @Override
    public abstract String getRemoteUrl(File var1);

    @Override
    public abstract long lastCommitTimeOfPath(File var1, Path var2);

    public abstract Optional<GitMercurialCommit> findCommitByTagOrBranch(File var1, String var2);

    public abstract List<GitMercurialCommit> getAllTags(File var1);

    public abstract Optional<GitMercurialCommit> findCommit(File var1, String var2);

    public abstract GitMercurialCommit headCommitOfBranch(File var1, String var2);

    public abstract void update(File var1);

    public abstract void clone(String var1, File var2);

    protected void run(File workingDir, List<String> cmds) {
        this.run(workingDir, cmds, Collections.emptyMap(), result -> null, result -> {
            throw BuildException.processInteractionFailed(cmds, Collections.emptyMap(), workingDir, result);
        });
    }

    protected <T> T run(File workingDir, List<String> cmds, Function<ProcessUtils.ProcessResult, T> successFunc) {
        return (T)this.run(workingDir, cmds, Collections.emptyMap(), successFunc, result -> {
            throw BuildException.processInteractionFailed(cmds, Collections.emptyMap(), workingDir, result);
        });
    }

    protected <T> T run(File workingDir, List<String> cmds, Function<ProcessUtils.ProcessResult, T> successFunc, Function<ProcessUtils.ProcessResult, T> failureFunc) {
        return this.run(workingDir, cmds, Collections.emptyMap(), successFunc, failureFunc);
    }

    protected <T> T run(File workingDir, List<String> cmds, Map<String, String> env, Function<ProcessUtils.ProcessResult, T> successFunc, Function<ProcessUtils.ProcessResult, T> failFunc) {
        this.ensureClientExists();
        Process process = this.processUtils.run(cmds, env, workingDir);
        try {
            ProcessUtils.ProcessResult result = this.processUtils.getResult(process);
            if (result.getCode() == 0) {
                return successFunc.apply(result);
            }
            return failFunc.apply(result);
        }
        catch (Exception e) {
            if (e instanceof BuildException) {
                throw e;
            }
            throw BuildException.processInteractionFailed(cmds, env, workingDir, e);
        }
    }

    protected void runWithProgress(List<String> cmds, GitClientLineConsumer stdoutLineConsumer, GitClientLineConsumer stderrLineConsumer) {
        this.runWithProgress(new File("."), cmds, stdoutLineConsumer, stderrLineConsumer);
    }

    protected void runWithProgress(File workingDir, List<String> cmds, GitClientLineConsumer stdoutLineConsumer, GitClientLineConsumer stderrLineConsumer) {
        this.ensureClientExists();
        Map<String, String> env = Collections.emptyMap();
        Process process = this.processUtils.run(cmds, env, workingDir);
        CountDownLatch latch = new CountDownLatch(2);
        try {
            new SubprocessReader(process::getErrorStream, stderrLineConsumer, latch).start();
            new SubprocessReader(process::getInputStream, stdoutLineConsumer, latch).start();
            latch.await();
            stderrLineConsumer.complete();
            stdoutLineConsumer.complete();
            if (process.waitFor() != 0) {
                throw BuildException.processInteractionFailed(cmds, env, workingDir, process.waitFor(), stdoutLineConsumer.getOutput(), stderrLineConsumer.getOutput());
            }
        }
        catch (Exception e) {
            throw BuildException.processInteractionFailed(cmds, env, workingDir, e);
        }
    }

    protected void ensureClientExists() {
    }
}

