/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.unsafe;

import com.github.blindpirate.gogradle.task.go.GoTestResultsProvider;
import com.github.blindpirate.gogradle.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.util.GradleVersion;
import org.joor.Reflect;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
public class GradleInternalAPI {
    private static final GradleVersion GRADLE_4_0 = GradleVersion.version((String)"4.0");
    private static final GradleVersion GRADLE_4_4 = GradleVersion.version((String)"4.4");

    public static void renderTestReport(List<TestClassResult> testResults, File outputDir) {
        GoTestResultsProvider provider = new GoTestResultsProvider(testResults);
        try {
            String executorClassName = GradleInternalAPI.isGradle4() ? "org.gradle.internal.operations.BuildOperationExecutor" : "org.gradle.internal.operations.BuildOperationProcessor";
            String testReportClassName = GradleInternalAPI.isAfterGradle44() ? "org.gradle.api.internal.tasks.testing.report.DefaultTestReport" : "org.gradle.api.internal.tasks.testing.junit.report.DefaultTestReport";
            Class<?> buildOperationProcessorClass = Class.forName(executorClassName);
            Class<?> defaultTestReportClass = Class.forName(testReportClassName);
            Constructor<?> constructor = defaultTestReportClass.getConstructor(buildOperationProcessorClass);
            Object buildOperationExecutor = Proxy.newProxyInstance(Gradle.class.getClassLoader(), new Class[]{buildOperationProcessorClass}, (InvocationHandler)new BuildOperationExecutorOrProcessor());
            Reflect.on(constructor.newInstance(buildOperationExecutor)).call("generateReport", new Object[]{provider, outputDir});
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionHandler.uncheckException(e);
        }
    }

    private static boolean isGradle4() {
        return GradleVersion.current().compareTo(GRADLE_4_0) >= 0;
    }

    private static boolean isAfterGradle44() {
        return GradleVersion.current().compareTo(GRADLE_4_4) >= 0;
    }

    private static class DefaultBuildOperationContext {
        private Throwable failure;
        private Object result;
        private String status;

        private DefaultBuildOperationContext() {
        }

        public void failed(Throwable t) {
            this.failure = t;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void thrown(Throwable t) {
            if (this.failure == null) {
                this.failure = t;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public String getStatus() {
            return this.status;
        }
    }

    private static class SerialBuildOperationQueue<T extends RunnableBuildOperation>
    implements BuildOperationQueue<T> {
        private Queue<RunnableBuildOperation> queue = new LinkedList<RunnableBuildOperation>();

        private SerialBuildOperationQueue() {
        }

        public void add(RunnableBuildOperation operation) {
            this.queue.add(operation);
        }

        public void cancel() {
            throw new UnsupportedOperationException();
        }

        public void waitForCompletion() throws MultipleBuildOperationFailures {
            try {
                for (RunnableBuildOperation operation : this.queue) {
                    if (GradleInternalAPI.isGradle4()) {
                        Class<?> contextClass = Class.forName("org.gradle.internal.operations.BuildOperationContext");
                        Object context = Reflect.on((Object)new DefaultBuildOperationContext()).as(contextClass);
                        Reflect.on((Object)operation).call("run", new Object[]{context});
                        continue;
                    }
                    Reflect.on((Object)operation).call("run");
                }
            }
            catch (ReflectiveOperationException e) {
                throw ExceptionHandler.uncheckException(e);
            }
        }

        public void setLogLocation(String logLocation) {
            throw new UnsupportedOperationException();
        }
    }

    private static class BuildOperationExecutorOrProcessor
    implements InvocationHandler {
        private BuildOperationExecutorOrProcessor() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("run".equals(method.getName()) && args[0] instanceof Action) {
                this.runAction(args);
            } else if ("runAll".equals(method.getName()) && args.length == 1) {
                this.runAction(args);
            } else if ("run".equals(method.getName()) && args[0] instanceof RunnableBuildOperation) {
                this.runOperation(args);
            } else {
                throw new UnsupportedOperationException();
            }
            return null;
        }

        private void runOperation(Object[] args) {
            SerialBuildOperationQueue queue = new SerialBuildOperationQueue();
            queue.add((BuildOperation)((RunnableBuildOperation)args[0]));
            queue.waitForCompletion();
        }

        private void runAction(Object[] args) {
            SerialBuildOperationQueue queue = new SerialBuildOperationQueue();
            ((Action)Action.class.cast(args[0])).execute(queue);
            queue.waitForCompletion();
        }
    }
}

