/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import com.github.blindpirate.gogradle.Go;
import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.common.GoSourceCodeFilter;
import com.github.blindpirate.gogradle.crossplatform.Arch;
import com.github.blindpirate.gogradle.crossplatform.GoBinaryManager;
import com.github.blindpirate.gogradle.crossplatform.Os;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;

public class GoBuild
extends Go {
    @Inject
    private GolangPluginSetting setting;
    @Inject
    private GoBinaryManager binaryManager;
    private static final Pattern TARGET_PLATFORMS_PATTERN = Pattern.compile("(\\s*\\w+-\\w+\\s*)(,\\s*\\w+-\\w+\\s*)*");
    private static final Pattern TARGET_PLATFORM_PATTERN = Pattern.compile("\\w+-\\w+");
    private static final String DEFAULT_OUTPUT_LOCATION = "./.gogradle/${PROJECT_NAME}-${GOOS}-${GOARCH}";
    private String outputLocation;
    private List<Pair<Os, Arch>> targetPlatforms = Collections.singletonList(Pair.of((Object)((Object)Os.getHostOs()), (Object)((Object)Arch.getHostArch())));

    public GoBuild() {
        this.setDescription("Run build and generate output.");
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    @Override
    public void afterEvaluate() {
        this.targetPlatforms.forEach(osArchPair -> {
            Os os = (Os)((Object)((Object)osArchPair.getLeft()));
            Arch arch = (Arch)((Object)((Object)osArchPair.getRight()));
            Go task = this.createSingleGoTask(os, arch);
            task.dependsOn(new Object[]{"installDependencies", "resolveBuildDependencies"});
            this.configureSubTask(task, os, arch);
        });
        if (!this.goActions.isEmpty()) {
            this.goActions.clear();
        }
    }

    private boolean noCustomActions() {
        return this.goActions.isEmpty();
    }

    private void configureSubTask(Go subTask, Os os, Arch arch) {
        this.configureStdoutStderr(subTask);
        subTask.setContinueOnFailure(this.continueOnFailure);
        this.configureActions(subTask);
        this.configureEnvironment(os, arch, subTask);
        this.configureInputsOutputs(subTask, os, arch);
        this.dependsOn(new Object[]{subTask});
    }

    private void configureInputsOutputs(Go subTask, Os os, Arch arch) {
        if (this.noCustomActions() || this.outputLocation != null) {
            subTask.getInputs().files(new Object[]{() -> GoSourceCodeFilter.filterGoFiles(this.getProjectDir(), GoSourceCodeFilter.SourceSetType.PROJECT_AND_VENDOR_BUILD_FILES)});
            subTask.getOutputs().file((Object)new File(this.getProjectDir(), this.getOutputLocation()));
            HashMap<String, Object> inputProperties = new HashMap<String, Object>();
            inputProperties.put("buildTags", () -> this.setting.getBuildTags());
            inputProperties.put("goVersion", () -> this.binaryManager.getGoVersion());
            inputProperties.put("environment", this.getEffectiveEnvironment(os, arch));
            subTask.getInputs().properties(inputProperties);
        }
    }

    public String getOutputLocation() {
        return this.outputLocation == null ? DEFAULT_OUTPUT_LOCATION : this.outputLocation;
    }

    private void configureStdoutStderr(Go subTask) {
        subTask.stdout(this.stdoutLineConsumer);
        subTask.stderr(this.stderrLineConsumer);
    }

    private void configureActions(Go subTask) {
        if (this.noCustomActions()) {
            subTask.go(Arrays.asList("build", "-o", this.getOutputLocation(), this.setting.getPackagePath()));
        } else {
            this.goActions.forEach(subTask::addGoAction);
        }
    }

    private void configureEnvironment(Os os, Arch arch, Go task) {
        Map<String, String> env = this.getEffectiveEnvironment(os, arch);
        env.putAll(this.environment);
        task.environment(env);
    }

    private Go createSingleGoTask(Os os, Arch arch) {
        String taskName = "build" + StringUtils.capitalizeFirstLetter(os.toString()) + StringUtils.capitalizeFirstLetter(arch.toString());
        return (Go)this.getProject().getTasks().create(taskName, Go.class);
    }

    @Deprecated
    public void setTargetPlatform(String targetPlatform) {
        Matcher matcher = TARGET_PLATFORMS_PATTERN.matcher(targetPlatform);
        Assert.isTrue(matcher.matches(), "Illegal target platform:" + targetPlatform);
        this.targetPlatforms = this.extractPlatforms(targetPlatform);
        this.removeDuplicates();
    }

    public void setTargetPlatform(List<String> targetPlatformList) {
        Assert.isNotEmpty(targetPlatformList, "Target platform cannot be empty!");
        Assert.isTrue(targetPlatformList.stream().allMatch(s -> TARGET_PLATFORM_PATTERN.matcher((CharSequence)s).matches()), "Illegal target platform:" + targetPlatformList);
        this.targetPlatforms = targetPlatformList.stream().map(this::extractOne).collect(Collectors.toList());
        this.removeDuplicates();
    }

    private void removeDuplicates() {
        this.targetPlatforms = new ArrayList<Pair<Os, Arch>>(new LinkedHashSet<Pair<Os, Arch>>(this.targetPlatforms));
    }

    private List<Pair<Os, Arch>> extractPlatforms(String targetPlatform) {
        String[] platforms = StringUtils.splitAndTrim(targetPlatform, ",");
        return Stream.of(platforms).map(this::extractOne).collect(Collectors.toList());
    }

    private Pair<Os, Arch> extractOne(String osAndArch) {
        String[] osArch = StringUtils.splitAndTrim(osAndArch, "\\-");
        Os os = Os.of(osArch[0]);
        Arch arch = Arch.of(osArch[1]);
        return Pair.of((Object)((Object)os), (Object)((Object)arch));
    }

    private Map<String, String> getEffectiveEnvironment(Os os, Arch arch) {
        Map<String, String> result = MapUtils.asMap("GOOS", os.toString(), "GOARCH", arch.toString(), "GOEXE", os.exeExtension());
        result.putAll(this.environment);
        return result;
    }
}

