/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task;

import com.github.blindpirate.gogradle.core.dependency.tree.DependencyTreeNode;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.task.ResolveBuildDependencies;
import com.github.blindpirate.gogradle.task.ResolveTestDependencies;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;

public class DependenciesTask
extends AbstractGolangTask {
    private static final Logger LOGGER = Logging.getLogger(DependenciesTask.class);

    public DependenciesTask() {
        this.setDescription("Displays all dependencies.");
        this.dependsOn(new Object[]{"resolveBuildDependencies", "resolveTestDependencies"});
    }

    @TaskAction
    public void displayDependencies() {
        this.setGogradleGlobalContext();
        DependencyTreeNode buildTree = this.getTask(ResolveBuildDependencies.class).getDependencyTree();
        DependencyTreeNode testTree = this.getTask(ResolveTestDependencies.class).getDependencyTree();
        this.display("build", buildTree);
        this.display("test", testTree);
    }

    private void display(String configuration, DependencyTreeNode tree) {
        LOGGER.quiet(configuration + ":");
        LOGGER.quiet(tree.output());
    }
}

