/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.crossplatform;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum Arch {
    I386{

        @Override
        public String toString() {
            return "386";
        }
    }
    ,
    AMD64,
    AMD64P32,
    ARM,
    ARMBE,
    ARM64,
    ARM64BE,
    PPC64,
    PPC64LE,
    MIPS,
    MIPSLE,
    MIPS64,
    MIPS64LE,
    MIPS64P32,
    MIPS64P32LE,
    PPC,
    S390,
    S390X,
    SPARC,
    SPARC64;

    private static Arch hostArch;
    private static final Map<String, Arch> ARCH_DETECTION_MAP;

    public String toString() {
        return this.name().toLowerCase();
    }

    public static Arch getHostArch() {
        if (hostArch == null) {
            hostArch = Arch.detectHostArch();
        }
        return hostArch;
    }

    public static Arch of(String lowercase) {
        for (Arch a : Arch.values()) {
            if (!a.toString().equals(lowercase)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unrecognized arch: " + lowercase);
    }

    private static Arch detectHostArch() {
        String arch = System.getProperty("os.arch");
        if (ARCH_DETECTION_MAP.containsKey(arch)) {
            return ARCH_DETECTION_MAP.get(arch);
        }
        throw new IllegalStateException("Unrecognized architecture:" + arch);
    }

    static {
        ARCH_DETECTION_MAP = ImmutableMap.builder().put((Object)"x86_64", (Object)AMD64).put((Object)"x64", (Object)AMD64).put((Object)"amd64", (Object)AMD64).put((Object)"x86_32", (Object)I386).put((Object)"x86", (Object)I386).put((Object)"x32", (Object)I386).put((Object)"i386", (Object)I386).put((Object)"i486", (Object)I386).put((Object)"i586", (Object)I386).put((Object)"i686", (Object)I386).put((Object)"arm", (Object)ARM).put((Object)"arm32", (Object)ARM).put((Object)"ppc", (Object)PPC).put((Object)"ppc32", (Object)PPC).put((Object)"ppc64", (Object)PPC64).put((Object)"ppc64le", (Object)PPC64LE).put((Object)"s390", (Object)S390).put((Object)"s390x", (Object)S390X).build();
    }
}

