/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce.strategy;

import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.produce.DependencyVisitor;
import com.github.blindpirate.gogradle.core.dependency.produce.strategy.DependencyProduceStrategy;
import com.github.blindpirate.gogradle.util.logging.DebugLog;
import java.io.File;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class DefaultDependencyProduceStrategy
implements DependencyProduceStrategy {
    @Override
    @DebugLog
    public GolangDependencySet produce(ResolvedDependency dependency, File rootDir, DependencyVisitor visitor, String configuration) {
        if (dependency.getSubpackages().contains("...")) {
            return this.visitAll(dependency, rootDir, visitor, configuration);
        }
        return visitor.visitSourceCodeDependencies(dependency, rootDir, configuration);
    }

    private GolangDependencySet visitAll(ResolvedDependency dependency, File rootDir, DependencyVisitor visitor, String configuration) {
        GolangDependencySet externalDependencies = visitor.visitExternalDependencies(dependency, rootDir, configuration);
        GolangDependencySet vendorDependencies = visitor.visitVendorDependencies(dependency, rootDir, configuration);
        List<GolangDependency> flatVendorDependencies = vendorDependencies.flatten();
        externalDependencies.removeAll(flatVendorDependencies);
        GolangDependencySet candidate = GolangDependencySet.merge(vendorDependencies, externalDependencies);
        if (candidate.isEmpty()) {
            candidate = visitor.visitSourceCodeDependencies(dependency, rootDir, configuration);
        }
        return candidate;
    }
}

