/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce.external.govendor;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.ResolvableGolangPackage;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VendorDotJsonModel {
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="ignore")
    private String ignore;
    @JsonProperty(value="rootPath")
    private String rootPath;
    @JsonProperty(value="package")
    private List<PackageBean> packageX;

    public List<Map<String, Object>> toNotations(PackagePathResolver packagePathResolver) {
        return this.packageX.stream().map(bean -> bean.toNotation(packagePathResolver)).collect(Collectors.toList());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PackageBean {
        @JsonProperty(value="checksumSHA1")
        private String checksumSHA1;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="origin")
        private String origin;
        @JsonProperty(value="revision")
        private String revision;
        @JsonProperty(value="revisionTime")
        private String revisionTime;

        Map<String, Object> toNotation(PackagePathResolver packagePathResolver) {
            Assert.isNotBlank(this.path);
            Map<String, Object> ret = MapUtils.asMapWithoutNull("name", this.path, "transitive", false);
            if (StringUtils.isNotBlank(this.origin)) {
                this.recognizeHostAndVendorPath(ret, packagePathResolver);
            } else if (StringUtils.isNotBlank(this.revision)) {
                ret.put("version", this.revision);
            }
            return ret;
        }

        private void recognizeHostAndVendorPath(Map<String, Object> ret, PackagePathResolver packagePathResolver) {
            GolangPackage pkg = packagePathResolver.produce(this.origin).get();
            Assert.isTrue(pkg instanceof ResolvableGolangPackage, "Cannot resolve package in vendor.json: " + this.origin);
            Path hostImportPath = ((ResolvableGolangPackage)ResolvableGolangPackage.class.cast(pkg)).getRootPath();
            Path vendorPath = hostImportPath.relativize(Paths.get(this.origin, new String[0]));
            Map<String, String> host = MapUtils.asMapWithoutNull("name", StringUtils.toUnixString(hostImportPath), "version", this.revision);
            ret.put("vendorPath", StringUtils.toUnixString(vendorPath));
            ret.put("host", host);
        }
    }
}

