/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.parse;

import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.parse.AutoConfigureMapNotationParser;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.VcsNotationDependency;
import com.github.blindpirate.gogradle.vcs.VcsType;
import com.github.blindpirate.gogradle.vcs.git.GitNotationDependency;
import com.github.blindpirate.gogradle.vcs.mercurial.MercurialNotationDependency;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class GitMercurialMapNotationParser
extends AutoConfigureMapNotationParser<VcsNotationDependency> {
    @Override
    protected void preConfigure(Map<String, Object> notation) {
        String version = MapUtils.getString(notation, "version");
        String tag = MapUtils.getString(notation, "tag");
        String branch = MapUtils.getString(notation, "branch");
        String commit = MapUtils.getString(notation, "commit");
        if (StringUtils.allBlank(version, tag, commit, branch)) {
            notation.put("commit", "LATEST_COMMIT");
        }
    }

    @Override
    protected Class<? extends NotationDependency> determineDependencyClass(Map<String, Object> notationMap) {
        VcsType vcsType = this.getVcsType(notationMap);
        Assert.isTrue(vcsType == VcsType.GIT || vcsType == VcsType.MERCURIAL);
        if (vcsType == VcsType.GIT) {
            return GitNotationDependency.class;
        }
        return MercurialNotationDependency.class;
    }

    private VcsType getVcsType(Map<String, Object> notationMap) {
        Optional<VcsType> vcsType = VcsType.of(MapUtils.getString(notationMap, "vcs"));
        if (vcsType.isPresent()) {
            return vcsType.get();
        }
        VcsGolangPackage pkg = MapUtils.getValue(notationMap, "package", VcsGolangPackage.class);
        Assert.isTrue(pkg != null, "Cannot found vcs in " + notationMap);
        return pkg.getVcsType();
    }
}

