/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.core.GolangCloneable;
import com.github.blindpirate.gogradle.core.cache.CacheScope;
import com.github.blindpirate.gogradle.core.dependency.AbstractGolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.util.Assert;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class GolangDependencySet
implements Set<GolangDependency>,
Serializable,
GolangCloneable {
    public static final Collector<GolangDependency, GolangDependencySet, GolangDependencySet> COLLECTOR = new Collector<GolangDependency, GolangDependencySet, GolangDependencySet>(){

        @Override
        public Supplier<GolangDependencySet> supplier() {
            return GolangDependencySet::new;
        }

        @Override
        public BiConsumer<GolangDependencySet, GolangDependency> accumulator() {
            return GolangDependencySet::add;
        }

        @Override
        public BinaryOperator<GolangDependencySet> combiner() {
            return (set1, set2) -> {
                set1.addAll((Collection<? extends GolangDependency>)set2);
                return set1;
            };
        }

        @Override
        public Function<GolangDependencySet, GolangDependencySet> finisher() {
            return set -> set;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return ImmutableSet.of((Object)((Object)Collector.Characteristics.UNORDERED));
        }
    };
    private TreeSet<GolangDependency> container = new TreeSet(Comparator.comparing(GolangDependency::getName));

    public GolangDependencySet(Collection<? extends GolangDependency> dependencies) {
        this.container.addAll(dependencies);
    }

    public GolangDependencySet() {
    }

    public Optional<GolangDependency> findByName(final String name) {
        AbstractGolangDependency dependency = new AbstractGolangDependency(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public ResolvedDependency resolve(ResolveContext context) {
                return null;
            }

            @Override
            public CacheScope getCacheScope() {
                return null;
            }
        };
        GolangDependency result = this.container.floor(dependency);
        if (result != null && !result.getName().equals(name)) {
            result = null;
        }
        return Optional.ofNullable(result);
    }

    public static GolangDependencySet merge(GolangDependencySet ... sets) {
        GolangDependencySet result = new GolangDependencySet();
        for (GolangDependencySet set : sets) {
            for (GolangDependency dependency : set) {
                if (result.contains(dependency)) continue;
                result.add(dependency);
            }
        }
        return result;
    }

    public List<GolangDependency> flatten() {
        ArrayList<GolangDependency> result = new ArrayList<GolangDependency>();
        this.forEach((Consumer<GolangDependency> & Serializable)dependency -> this.dfs((GolangDependency)dependency, (List<GolangDependency>)result, 0));
        return result;
    }

    private void dfs(GolangDependency dependency, List<GolangDependency> result, int depth) {
        Assert.isTrue(depth < 100);
        result.add(dependency);
        if (dependency instanceof ResolvedDependency) {
            ((ResolvedDependency)ResolvedDependency.class.cast(dependency)).getDependencies().forEach((Consumer<GolangDependency> & Serializable)subDependency -> this.dfs((GolangDependency)subDependency, result, depth + 1));
        }
    }

    public static GolangDependencySet empty() {
        return new GolangDependencySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GolangDependencySet that = (GolangDependencySet)o;
        return Objects.equals(this.container, that.container);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.container);
    }

    @Override
    public int size() {
        return this.container.size();
    }

    @Override
    public boolean isEmpty() {
        return this.container.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.container.contains(o);
    }

    @Override
    public Iterator<GolangDependency> iterator() {
        return this.container.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.container.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.container.toArray(a);
    }

    @Override
    public boolean add(GolangDependency dependency) {
        return this.container.add(dependency);
    }

    @Override
    public boolean remove(Object o) {
        return this.container.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.container.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends GolangDependency> c) {
        return this.container.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.container.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int originalSize = this.container.size();
        c.forEach(this.container::remove);
        return this.container.size() < originalSize;
    }

    @Override
    public void clear() {
        this.container.clear();
    }

    @Override
    public GolangDependencySet clone() {
        try {
            GolangDependencySet ret = (GolangDependencySet)super.clone();
            ret.container = new TreeSet(Comparator.comparing(GolangDependency::getName));
            this.container.forEach(item -> ret.add((GolangDependency)item.clone()));
            return ret;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

