/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.cache;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.cache.PersistenceCache;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gradle.api.Project;

@Singleton
public class PersistenceResolvedToDependenciesCache
extends PersistenceCache<ResolvedDependency, GolangDependencySet> {
    private final PackagePathResolver packagePathResolver;

    @Inject
    public PersistenceResolvedToDependenciesCache(Project project, PackagePathResolver packagePathResolver) {
        super(project, "PersistenceResolvedToDependenciesCache-0.8.bin");
        this.packagePathResolver = packagePathResolver;
    }

    @Override
    public void load() {
        super.load();
        this.removeCachedItemWhosePackageHasChanged();
    }

    private void removeCachedItemWhosePackageHasChanged() {
        List<Map.Entry> entriesToRemove = this.container.entrySet().stream().filter(entry -> !this.shouldBePreserved((Map.Entry<ResolvedDependency, GolangDependencySet>)entry)).collect(Collectors.toList());
        entriesToRemove.forEach(entry -> {
            GolangDependencySet cfr_ignored_0 = (GolangDependencySet)this.container.remove(entry.getKey());
        });
    }

    private boolean shouldBePreserved(Map.Entry<ResolvedDependency, GolangDependencySet> entry) {
        List<GolangDependency> dependencies = entry.getValue().flatten();
        return dependencies.stream().allMatch(this::packageIsSame);
    }

    private boolean packageIsSame(GolangDependency dependency) {
        GolangPackage newPkg = this.packagePathResolver.produce(dependency.getName()).get();
        GolangPackage oldPkg = dependency.getPackage();
        return newPkg.equals(oldPkg);
    }
}

