/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.IncompleteGolangPackage;
import com.github.blindpirate.gogradle.core.ResolvableGolangPackage;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public class LocalDirectoryGolangPackage
extends ResolvableGolangPackage {
    private String dir;

    private LocalDirectoryGolangPackage(Path rootPath, Path path, String dir) {
        super(rootPath, path);
        this.dir = dir;
    }

    public String getDir() {
        return this.dir;
    }

    @Override
    protected Optional<GolangPackage> longerPath(Path packagePath) {
        return Optional.of(LocalDirectoryGolangPackage.of(this.getRootPath(), packagePath, this.dir));
    }

    @Override
    protected Optional<GolangPackage> shorterPath(Path packagePath) {
        if (StringUtils.toUnixString(packagePath).length() < this.getRootPathString().length()) {
            return Optional.of(IncompleteGolangPackage.of(packagePath));
        }
        return Optional.of(LocalDirectoryGolangPackage.of(this.getRootPath(), packagePath, this.dir));
    }

    public static LocalDirectoryGolangPackage of(Path rootPath, Path path, String dir) {
        return new LocalDirectoryGolangPackage(rootPath, path, dir);
    }

    public static LocalDirectoryGolangPackage of(String rootPath, String path, String dir) {
        return new LocalDirectoryGolangPackage(Paths.get(rootPath, new String[0]), Paths.get(path, new String[0]), dir);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LocalDirectoryGolangPackage that = (LocalDirectoryGolangPackage)o;
        return Objects.equals(this.dir, that.dir);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dir);
    }
}

