/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.common;

import com.github.blindpirate.gogradle.common.AbstractFileFilter;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class GoSourceCodeFilter
extends AbstractFileFilter {
    private Predicate<File> filePredicate;
    private Predicate<File> dirPredicate;

    public static Collection<File> filterGoFiles(File projectDir, String configuration) {
        return "build".equals(configuration) ? GoSourceCodeFilter.filterGoFiles(projectDir, SourceSetType.PROJECT_BUILD_FILES_ONLY) : GoSourceCodeFilter.filterGoFiles(projectDir, SourceSetType.PROJECT_TEST_FILES_ONLY);
    }

    public static Collection<File> filterGoFiles(File projectDir, SourceSetType sourceSetType) {
        Collection<File> projectGoFiles = GoSourceCodeFilter.filterProjectGoFiles(projectDir, sourceSetType);
        if (sourceSetType.containsVendorBuildFiles && IOUtils.isValidDirectory(new File(projectDir, "vendor"))) {
            HashSet<File> result = new HashSet<File>(projectGoFiles);
            result.addAll(GoSourceCodeFilter.filterVendorGoFiles(projectDir));
            return result;
        }
        return projectGoFiles;
    }

    public static Collection<File> filterTestsMatchingPattern(File projectDir, List<String> patterns) {
        WildcardFileFilter wildcardFileFilter = new WildcardFileFilter(patterns);
        return GoSourceCodeFilter.filterGoFiles(projectDir, SourceSetType.PROJECT_TEST_FILES_ONLY).stream().filter(arg_0 -> ((WildcardFileFilter)wildcardFileFilter).accept(arg_0)).collect(Collectors.toList());
    }

    private static Collection<File> filterVendorGoFiles(File projectDir) {
        Predicate<File> goFilesPredicate = file -> GoSourceCodeFilter.containThisFile(file, true, false);
        return IOUtils.filterFilesRecursively(new File(projectDir, "vendor"), (IOFileFilter)new GoSourceCodeFilter(goFilesPredicate));
    }

    private static Collection<File> filterProjectGoFiles(File projectDir, SourceSetType sourceSetType) {
        Predicate<File> notVendorPredicate = dir -> !GoSourceCodeFilter.isVendorDirectoryOfProject(dir, projectDir);
        Predicate<File> projectGoFilesPredicate = file -> GoSourceCodeFilter.containThisFile(file, sourceSetType);
        return IOUtils.filterFilesRecursively(projectDir, (IOFileFilter)new GoSourceCodeFilter(projectGoFilesPredicate, notVendorPredicate));
    }

    private static boolean containThisFile(File file, SourceSetType sourceSetType) {
        return GoSourceCodeFilter.containThisFile(file, sourceSetType.containsProjectBuildFiles, sourceSetType.containsProjectTestFiles);
    }

    private static boolean containThisFile(File file, boolean containsBuildFiles, boolean containsTestFiles) {
        String fileName = file.getName();
        if (!fileName.endsWith(".go")) {
            return false;
        }
        if (fileName.endsWith("_test.go")) {
            return containsTestFiles;
        }
        return containsBuildFiles;
    }

    private static boolean isVendorDirectoryOfProject(File dir, File projectDir) {
        return "vendor".equals(dir.getName()) && projectDir.equals(dir.getParentFile());
    }

    private GoSourceCodeFilter(Predicate<File> filePredicate) {
        this(filePredicate, dir -> true);
    }

    private GoSourceCodeFilter(Predicate<File> filePredicate, Predicate<File> dirPredicate) {
        this.filePredicate = filePredicate;
        this.dirPredicate = dirPredicate;
    }

    @Override
    protected boolean acceptFile(File file) {
        if (StringUtils.fileNameStartsWithDotOrUnderline(file)) {
            return false;
        }
        return this.filePredicate.test(file);
    }

    @Override
    protected boolean acceptDir(File dir) {
        if (Files.isSymbolicLink(dir.toPath())) {
            return false;
        }
        if (StringUtils.fileNameStartsWithDotOrUnderline(dir)) {
            return false;
        }
        if (StringUtils.fileNameEqualsAny(dir, "testdata")) {
            return false;
        }
        return this.dirPredicate.test(dir);
    }

    public static enum SourceSetType {
        PROJECT_BUILD_FILES_ONLY(true, false, false),
        PROJECT_TEST_FILES_ONLY(false, true, false),
        PROJECT_AND_VENDOR_BUILD_FILES(true, false, true),
        PROJECT_TEST_AND_VENDOR_BUILD_FILES(true, true, true);

        private boolean containsProjectBuildFiles;
        private boolean containsProjectTestFiles;
        private boolean containsVendorBuildFiles;

        private SourceSetType(boolean containsProjectBuildFiles, boolean containsProjectTestFiles, boolean containsVendorBuildFiles) {
            this.containsProjectBuildFiles = containsProjectBuildFiles;
            this.containsProjectTestFiles = containsProjectTestFiles;
            this.containsVendorBuildFiles = containsVendorBuildFiles;
        }
    }
}

