/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task;

import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.lock.LockedDependencyManager;
import com.github.blindpirate.gogradle.core.dependency.tree.DependencyTreeNode;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.task.ResolveBuildDependencies;
import com.github.blindpirate.gogradle.task.ResolveTestDependencies;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.tasks.TaskAction;

public class GoLock
extends AbstractGolangTask {
    @Inject
    private LockedDependencyManager lockedDependencyManager;

    public GoLock() {
        this.setDescription("Generate lockfile for current project.");
        this.dependsOn(new Object[]{"resolveBuildDependencies", "resolveTestDependencies"});
    }

    @TaskAction
    public void lock() {
        this.setGogradleGlobalContext();
        DependencyTreeNode buildDependencyTree = this.getTask(ResolveBuildDependencies.class).getDependencyTree();
        DependencyTreeNode testDependencyTree = this.getTask(ResolveTestDependencies.class).getDependencyTree();
        this.lockedDependencyManager.lock(this.toResolveDependencySet(buildDependencyTree), this.toResolveDependencySet(testDependencyTree));
    }

    private Set<ResolvedDependency> toResolveDependencySet(DependencyTreeNode root) {
        return root.flatten().stream().map(dependency -> (ResolvedDependency)dependency).collect(Collectors.toSet());
    }
}

