/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task;

import com.github.blindpirate.gogradle.core.GolangConfigurationManager;
import com.github.blindpirate.gogradle.core.dependency.GogradleRootProject;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.UnrecognizedNotationDependency;
import com.github.blindpirate.gogradle.core.dependency.lock.DefaultLockedDependencyManager;
import com.github.blindpirate.gogradle.core.dependency.produce.DefaultDependencyVisitor;
import com.github.blindpirate.gogradle.core.dependency.produce.DependencyVisitor;
import com.github.blindpirate.gogradle.core.dependency.produce.ExternalDependencyFactory;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;

public class GoInit
extends AbstractGolangTask {
    private static final int DEFAULT_INDENT = 4;
    private static final Logger LOGGER = Logging.getLogger(GoInit.class);
    @Inject
    @DefaultDependencyVisitor.ExternalDependencyFactories
    private List<ExternalDependencyFactory> externalDependencyFactories;
    @Inject
    private GogradleRootProject gogradleRootProject;
    @Inject
    private DependencyVisitor visitor;
    @Inject
    private GolangConfigurationManager configurationManager;

    public GoInit() {
        this.setDescription("Import dependencies from other dependency management tools.");
        this.dependsOn(new Object[]{"goPrepare"});
    }

    @TaskAction
    void init() {
        this.setGogradleGlobalContext();
        File rootDir = this.getProjectDir();
        if (this.dependenciesInBuildDotGradleExists() || new File(rootDir, "gogradle.lock").exists()) {
            LOGGER.warn("This project seems to have been initialized already, skip.");
            return;
        }
        Optional<ExternalDependencyFactory> externalDependencyFactory = this.findExternalDependencyFactory(rootDir);
        if (externalDependencyFactory.isPresent()) {
            this.initByExternalLockfiles(externalDependencyFactory.get(), rootDir);
        } else {
            this.initBySourceCodeScan(rootDir);
        }
    }

    private boolean dependenciesInBuildDotGradleExists() {
        return this.configurationManager.getByName("build").hasFirstLevelDependencies() || this.configurationManager.getByName("test").hasFirstLevelDependencies();
    }

    private void initBySourceCodeScan(File rootDir) {
        GolangDependencySet buildDeps = this.visitor.visitSourceCodeDependencies(this.gogradleRootProject, rootDir, "build");
        GolangDependencySet testDeps = this.visitor.visitSourceCodeDependencies(this.gogradleRootProject, rootDir, "test");
        testDeps.removeAll(buildDeps);
        this.appendToBuildDotGradle(rootDir, this.convertToNotationMaps(buildDeps), this.convertToNotationMaps(testDeps));
    }

    private List<Map<String, Object>> convertToNotationMaps(GolangDependencySet set) {
        return set.stream().filter(dependency -> !(dependency instanceof UnrecognizedNotationDependency)).map(dependency -> ImmutableMap.of((Object)"name", (Object)dependency.getName())).collect(Collectors.toList());
    }

    private void initByExternalLockfiles(ExternalDependencyFactory factory, File rootDir) {
        List<Map<String, Object>> buildDependencies = factory.extractNotations(this.gogradleRootProject, rootDir, "build");
        List<Map<String, Object>> testDependencies = factory.extractNotations(this.gogradleRootProject, rootDir, "test");
        this.appendToBuildDotGradle(rootDir, buildDependencies, testDependencies);
    }

    private void appendToBuildDotGradle(File rootDir, List<Map<String, Object>> buildDependencies, List<Map<String, Object>> testDependencies) {
        StringBuilder sb = new StringBuilder();
        sb.append("\ndependencies {\n");
        StringUtils.appendNSpaces(sb, 4);
        sb.append("golang {\n");
        buildDependencies.forEach(d -> this.appendOneLine(sb, "build", (Map<String, Object>)d));
        testDependencies.forEach(d -> this.appendOneLine(sb, "test", (Map<String, Object>)d));
        StringUtils.appendNSpaces(sb, 4);
        sb.append("}\n}");
        IOUtils.append(new File(rootDir, "build.gradle"), sb.toString());
    }

    private void appendOneLine(StringBuilder sb, String configuration, Map<String, Object> dependencyMap) {
        StringUtils.appendNSpaces(sb, 8);
        sb.append(configuration).append("(");
        sb.append(InvokerHelper.invokeMethod(dependencyMap, (String)"inspect", (Object)new Object[0]).toString());
        sb.append(")\n");
    }

    private Optional<ExternalDependencyFactory> findExternalDependencyFactory(File rootDir) {
        return this.externalDependencyFactories.stream().filter(factory -> !(factory instanceof DefaultLockedDependencyManager)).filter(factory -> factory.canRecognize(rootDir)).findFirst();
    }
}

