/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.pack.AbstractPackagePathResolver;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class VcsPackagePathResolver
extends AbstractPackagePathResolver {
    @Override
    protected GolangPackage doProduce(String packagePath) {
        Pair rootPathAndVcsType = StringUtils.eachSubPath(packagePath).map(subPath -> Pair.of((Object)subPath, (Object)((Object)this.findEndingVcs((String)subPath)))).filter(pair -> pair.getRight() != null).findFirst().get();
        String rootPath = (String)rootPathAndVcsType.getLeft();
        VcsType vcsType = (VcsType)((Object)rootPathAndVcsType.getRight());
        GolangRepository repository = GolangRepository.newOriginalRepository(vcsType, vcsType.getSchemes().stream().map(scheme -> scheme.buildUrl(rootPath)).collect(Collectors.toList()));
        return VcsGolangPackage.builder().withPath(packagePath).withRootPath(rootPath).withRepository(repository).build();
    }

    @Override
    protected boolean isIncomplete(String packagePath) {
        return false;
    }

    @Override
    protected boolean cannotRecognize(String packagePath) {
        return StringUtils.eachSubPathReverse(packagePath).map(this::findEndingVcs).allMatch(Objects::isNull);
    }

    private VcsType findEndingVcs(String subPath) {
        return Stream.of(VcsType.values()).filter(vcsType -> subPath.endsWith(vcsType.getSuffix())).findAny().orElse(null);
    }
}

