/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.pack.AbstractPackagePathResolver;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Singleton;

@Singleton
public class IBMDevOpsPackagePathResolver
extends AbstractPackagePathResolver {
    private static final String HUB_JAZZ_HOST = "hub.jazz.net";

    @Override
    protected GolangPackage doProduce(String packagePath) {
        Path path = Paths.get(packagePath, new String[0]);
        Path rootPath = path.subpath(0, 4);
        GolangRepository repository = GolangRepository.newOriginalRepository(VcsType.GIT, "https://" + StringUtils.toUnixString(rootPath));
        return VcsGolangPackage.builder().withPath(path).withRootPath(rootPath).withRepository(repository).build();
    }

    @Override
    protected boolean isIncomplete(String packagePath) {
        return Paths.get(packagePath, new String[0]).getNameCount() < 4;
    }

    @Override
    protected boolean cannotRecognize(String packagePath) {
        return !HUB_JAZZ_HOST.equals(Paths.get(packagePath, new String[0]).getName(0).toString());
    }
}

