/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.mode;

import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;

public enum BuildMode {
    DEVELOP("DEV"){

        @Override
        public GolangDependencySet determine(GolangDependencySet declaredDependencies, GolangDependencySet lockedDependencies) {
            return declaredDependencies;
        }
    }
    ,
    REPRODUCIBLE("REP"){

        @Override
        public GolangDependencySet determine(GolangDependencySet declaredDependencies, GolangDependencySet lockedDependencies) {
            return lockedDependencies;
        }
    };

    private final String abbr;

    private BuildMode(String abbr) {
        this.abbr = abbr;
    }

    public String getAbbr() {
        return this.abbr;
    }

    public abstract GolangDependencySet determine(GolangDependencySet var1, GolangDependencySet var2);

    @Nonnull
    public static BuildMode fromString(@Nonnull String string) {
        String proposed = string.toUpperCase();
        Optional<BuildMode> bm = Arrays.stream(BuildMode.values()).filter(v -> v.name().equals(proposed) || v.abbr.equals(proposed)).findAny();
        if (bm.isPresent()) {
            return bm.get();
        }
        throw new IllegalArgumentException(MessageFormat.format("Unable to convert {} to an instance of BuildMode", string));
    }
}

