/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce.external.gopm;

import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class GopmfileParser {
    private static final String DEPS_SECTION = "[deps]";
    private static final String BRANCH_KEYWORD = "branch:";
    private static final String TAG_KEYWORD = "tag:";
    private static final String COMMIT_KEYWORD = "commit:";
    private static final String TARGET_SECTION = "[target]";
    private static final String RES_SECTION = "[res]";

    public List<Map<String, Object>> parse(File file) {
        List<String> lines = IOUtils.readLines(file).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        int targetLineIndex = this.findKeyworkIndex(lines, TARGET_SECTION);
        int depsLineIndex = this.findKeyworkIndex(lines, DEPS_SECTION);
        int resLineIndex = this.findKeyworkIndex(lines, RES_SECTION);
        if (depsLineIndex == -1 || depsLineIndex == lines.size() - 1) {
            return Collections.emptyList();
        }
        int nextSectionIndex = this.determineNextSectionIndex(lines, targetLineIndex, depsLineIndex, resLineIndex);
        List<String> depsLines = lines.subList(depsLineIndex + 1, nextSectionIndex);
        return this.parseLines(depsLines);
    }

    private int determineNextSectionIndex(List<String> lines, int targetLineIndex, int depsLineIndex, int resLineIndex) {
        int nextSectionIndex = lines.size();
        if (targetLineIndex > depsLineIndex || resLineIndex > depsLineIndex) {
            nextSectionIndex = Math.max(targetLineIndex, resLineIndex);
        }
        return nextSectionIndex;
    }

    private int findKeyworkIndex(List<String> lines, String keyword) {
        for (int i = 0; i < lines.size(); ++i) {
            if (!lines.get(i).trim().startsWith(keyword)) continue;
            return i;
        }
        return -1;
    }

    private List<Map<String, Object>> parseLines(List<String> deps) {
        return deps.stream().map(this::parseLine).filter(Objects::nonNull).map(this::toNotation).collect(Collectors.toList());
    }

    private Pair<String, String> parseLine(String line) {
        String[] nameAndValue = StringUtils.splitAndTrim(line, "=");
        String name = nameAndValue[0];
        String value = nameAndValue.length > 1 ? nameAndValue[1] : "";
        return Pair.of((Object)name, (Object)value);
    }

    private Map<String, Object> toNotation(Pair<String, String> nameAndValue) {
        String name = (String)nameAndValue.getLeft();
        String value = (String)nameAndValue.getRight();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("name", name);
        if (value.startsWith(BRANCH_KEYWORD)) {
            ret.put("branch", value.substring(BRANCH_KEYWORD.length()));
        } else if (value.startsWith(TAG_KEYWORD)) {
            ret.put("tag", value.substring(TAG_KEYWORD.length()));
        } else if (value.startsWith(COMMIT_KEYWORD)) {
            ret.put("commit", value.substring(COMMIT_KEYWORD.length()));
        } else if (StringUtils.isNotBlank(value)) {
            ret.put("dir", value);
        }
        return ret;
    }
}

