/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce.external.glide;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GlideDotLockModel {
    @JsonProperty(value="hash")
    private String hash;
    @JsonProperty(value="updated")
    private String updated;
    @JsonProperty(value="imports")
    private List<ImportBean> imports;
    @JsonProperty(value="testImports")
    private List<ImportBean> testImports;

    public List<Map<String, Object>> toBuildNotations() {
        if (this.imports == null) {
            return Collections.emptyList();
        }
        return this.imports.stream().map(ImportBean::toNotation).collect(Collectors.toList());
    }

    public List<Map<String, Object>> toTestNotations() {
        if (this.testImports == null) {
            return Collections.emptyList();
        }
        return this.testImports.stream().map(ImportBean::toNotation).collect(Collectors.toList());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ImportBean {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="vcs")
        private String vcs;
        @JsonProperty(value="repo")
        private String repo;
        @JsonProperty(value="subpackages")
        private List<String> subpackages;

        public Map<String, Object> toNotation() {
            Assert.isNotBlank(this.name);
            Map<String, Object> ret = MapUtils.asMapWithoutNull("name", this.name, "version", this.version, "url", this.repo, "vcs", this.vcs, "transitive", false);
            if (this.subpackages != null) {
                HashSet realSubpackages = Sets.newHashSet((Object[])new String[]{"."});
                realSubpackages.addAll(this.subpackages);
                ret.put("subpackages", realSubpackages);
            }
            return ret;
        }
    }
}

