/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class FirstPassVendorDirectoryVisitor
extends SimpleFileVisitor<Path> {
    private final PackagePathResolver packagePathResolver;
    private final Path parentVendor;

    public FirstPassVendorDirectoryVisitor(Path parentVendor, PackagePathResolver packagePathResolver) {
        this.packagePathResolver = packagePathResolver;
        this.parentVendor = parentVendor;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path currentPath, BasicFileAttributes attrs) {
        if (currentPath == this.parentVendor) {
            return FileVisitResult.CONTINUE;
        }
        String packagePath = StringUtils.toUnixString(this.parentVendor.relativize(currentPath));
        GolangPackage golangPackage = this.packagePathResolver.produce(packagePath).get();
        if (golangPackage instanceof VcsGolangPackage) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }
}

