/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce;

import com.github.blindpirate.gogradle.core.dependency.GogradleRootProject;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.parse.MapNotationParser;
import com.github.blindpirate.gogradle.core.pack.DefaultPackagePathResolver;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.core.pack.StandardPackagePathResolver;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.DependencySetUtils;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public abstract class ExternalDependencyFactory {
    private Map<String, Function<File, List>> adapters = ImmutableMap.of((Object)"build", this::adapt, (Object)"test", this::adaptTest);
    @Inject
    protected MapNotationParser mapNotationParser;
    @Inject
    @DefaultPackagePathResolver.AllPackagePathResolvers
    protected PackagePathResolver packagePathResolver;
    @Inject
    private StandardPackagePathResolver standardPackagePathResolver;
    @Inject
    private GogradleRootProject gogradleRootProject;

    public abstract String identityFileName();

    public GolangDependencySet produce(ResolvedDependency resolvedDependency, File rootDir, String configuration) {
        List<Map<String, Object>> mapNotations = this.extractNotations(resolvedDependency, rootDir, configuration);
        mapNotations = this.removeStandardAndParentPackages(mapNotations, resolvedDependency);
        return DependencySetUtils.parseMany(mapNotations, this.mapNotationParser);
    }

    public List<Map<String, Object>> extractNotations(ResolvedDependency parent, File rootDir, String configuration) {
        File identityFile = this.identityFile(rootDir);
        return this.removeStandardAndParentPackages(this.adapters.get(configuration).apply(identityFile), parent);
    }

    public boolean canRecognize(File rootDir) {
        return this.identityFile(rootDir).isFile();
    }

    private List<Map<String, Object>> removeStandardAndParentPackages(List<Map<String, Object>> packages, ResolvedDependency resolvedDependency) {
        return packages.stream().filter(pkg -> {
            String path = MapUtils.getString(pkg, "name", "");
            return !this.standardPackagePathResolver.isStandardPackage(Paths.get(path, new String[0])) && !StringUtils.pathStartsWith(path, resolvedDependency.getName()) && !StringUtils.pathStartsWith(path, this.gogradleRootProject.getName());
        }).collect(Collectors.toList());
    }

    protected List<Map<String, Object>> adaptTest(File identityFile) {
        return Collections.emptyList();
    }

    protected abstract List<Map<String, Object>> adapt(File var1);

    private File identityFile(File rootDir) {
        String identityFile = this.identityFileName();
        Assert.isNotBlank(identityFile, "Identity file must not be empty!");
        return new File(rootDir, identityFile);
    }
}

