/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.parse;

import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.parse.MapNotationParser;
import com.github.blindpirate.gogradle.core.dependency.parse.NotationConverter;
import com.github.blindpirate.gogradle.core.dependency.parse.NotationParser;
import com.github.blindpirate.gogradle.core.exceptions.DependencyResolutionException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultNotationParser
implements NotationParser<Object> {
    private final MapNotationParser mapNotationParser;
    private final NotationConverter notationConverter;

    @Inject
    public DefaultNotationParser(MapNotationParser mapNotationParser, NotationConverter notationConverter) {
        this.mapNotationParser = mapNotationParser;
        this.notationConverter = notationConverter;
    }

    @Override
    public GolangDependency parse(Object notation) {
        Map<String, Object> notationMap = this.convertToMap(notation);
        return this.mapNotationParser.parse(notationMap);
    }

    private Map<String, Object> convertToMap(Object notation) {
        if (notation instanceof String) {
            return this.notationConverter.convert((String)notation);
        }
        if (notation instanceof Map) {
            return (Map)notation;
        }
        throw DependencyResolutionException.cannotParseNotation(notation);
    }
}

