/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.core.dependency.AbstractNotationDependency;
import com.github.blindpirate.gogradle.core.dependency.DependencyRegistry;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logging;
import org.slf4j.Logger;

public class DefaultDependencyRegistry
implements DependencyRegistry {
    private static final Logger LOGGER = Logging.getLogger(DefaultDependencyRegistry.class);
    private final PackagePathResolver packagePathResolver;
    private final Map<String, SameResolvedDependencyInAllVersions> packages = new HashMap<String, SameResolvedDependencyInAllVersions>();

    public DefaultDependencyRegistry(PackagePathResolver packagePathResolver) {
        this.packagePathResolver = packagePathResolver;
    }

    @Override
    public synchronized boolean register(ResolvedDependency dependencyToResolve) {
        SameResolvedDependencyInAllVersions allVersions = this.getAllVersions(dependencyToResolve.getName());
        if (allVersions.noValidVersionExists()) {
            LOGGER.debug("{} doesn't exit in registry, add it.", (Object)dependencyToResolve);
            allVersions.add(dependencyToResolve);
            return true;
        }
        ResolvedDependencyWithReferenceCount head = allVersions.headOfValidVersions();
        int compareResult = PackageComparator.INSTANCE.compare(dependencyToResolve, head.resolvedDependency);
        if (this.currentDependencyEqualsLatestOne(compareResult)) {
            LOGGER.debug("Same version of {} already exited in registry, increase reference count to {}", (Object)dependencyToResolve, (Object)head.referenceCount);
            head.referenceCount++;
            return false;
        }
        if (this.currentDependencyShouldReplaceExistedOnes(compareResult)) {
            LOGGER.debug("{} is newer, replace the old version {} in registry", (Object)dependencyToResolve, (Object)head.resolvedDependency);
            allVersions.onlyDecreaseDescendantsReferenceCount();
            allVersions.add(dependencyToResolve);
            return true;
        }
        LOGGER.debug("{} is older, do nothing.", (Object)dependencyToResolve);
        allVersions.addEvictedDependency(dependencyToResolve);
        return false;
    }

    @Override
    public synchronized Optional<ResolvedDependency> retrieve(String name) {
        return this.getAllVersions(name).retrieve();
    }

    private void decreaseSelfAndAllDescendantsReferenceCount(ResolvedDependency target) {
        SameResolvedDependencyInAllVersions allVersions = this.getAllVersions(target.getName());
        allVersions.decreaseReferenceCount(target);
        this.decreaseAllDescendantsReferenceCount(target);
    }

    private void decreaseAllDescendantsReferenceCount(ResolvedDependency target) {
        target.getDependencies().stream().map(this::toResolvedDependency).filter(Optional::isPresent).map(Optional::get).forEach(this::decreaseSelfAndAllDescendantsReferenceCount);
    }

    private boolean currentDependencyShouldReplaceExistedOnes(int compareResult) {
        return compareResult < 0;
    }

    private boolean currentDependencyEqualsLatestOne(int compareResult) {
        return compareResult == 0;
    }

    private Optional<ResolvedDependency> toResolvedDependency(GolangDependency dependency) {
        if (dependency instanceof AbstractNotationDependency && ((AbstractNotationDependency)AbstractNotationDependency.class.cast(dependency)).hasBeenResolved()) {
            return Optional.of(dependency.resolve(null));
        }
        if (dependency instanceof ResolvedDependency) {
            return Optional.of((ResolvedDependency)ResolvedDependency.class.cast(dependency));
        }
        return Optional.empty();
    }

    private SameResolvedDependencyInAllVersions getAllVersions(String name) {
        SameResolvedDependencyInAllVersions allVersions = this.packages.get(name = this.packagePathResolver.produce(name).get().getRootPathString());
        if (allVersions == null) {
            allVersions = new SameResolvedDependencyInAllVersions();
            this.packages.put(name, allVersions);
        }
        return allVersions;
    }

    private static enum PackageComparator implements Comparator<ResolvedDependency>
    {
        INSTANCE;


        @Override
        public int compare(ResolvedDependency pkg1, ResolvedDependency pkg2) {
            if (pkg1.isFirstLevel() && pkg2.isFirstLevel()) {
                throw new IllegalStateException("First-level package " + pkg1.getName() + " conflict!");
            }
            if (pkg1.isFirstLevel() && !pkg2.isFirstLevel()) {
                return -1;
            }
            if (pkg2.isFirstLevel() && !pkg1.isFirstLevel()) {
                return 1;
            }
            return Long.compare(pkg2.getUpdateTime(), pkg1.getUpdateTime());
        }
    }

    private static class ResolvedDependencyWithReferenceCount {
        private static final Comparator<ResolvedDependencyWithReferenceCount> COMPARATOR = Comparator.comparing(ResolvedDependencyWithReferenceCount::getResolvedDependency, PackageComparator.INSTANCE);
        private final ResolvedDependency resolvedDependency;
        private int referenceCount;

        private ResolvedDependency getResolvedDependency() {
            return this.resolvedDependency;
        }

        private ResolvedDependencyWithReferenceCount(ResolvedDependency resolvedDependency) {
            this.resolvedDependency = resolvedDependency;
            this.referenceCount = 1;
        }

        static /* synthetic */ Comparator access$800() {
            return COMPARATOR;
        }
    }

    private class SameResolvedDependencyInAllVersions {
        private PriorityQueue<ResolvedDependencyWithReferenceCount> validVersions = new PriorityQueue(ResolvedDependencyWithReferenceCount.access$800());
        private PriorityQueue<ResolvedDependency> evictedVersions = new PriorityQueue<ResolvedDependency>(PackageComparator.INSTANCE);

        private SameResolvedDependencyInAllVersions() {
        }

        private void add(ResolvedDependency dependency) {
            this.validVersions.add(new ResolvedDependencyWithReferenceCount(dependency));
            this.evictedVersions.remove(dependency);
        }

        private void addEvictedDependency(ResolvedDependency dependency) {
            if (!this.evictedVersions.contains(dependency)) {
                this.evictedVersions.add(dependency);
            }
        }

        private Optional<ResolvedDependencyWithReferenceCount> find(ResolvedDependency resolvedDependency) {
            return this.validVersions.stream().filter(pkgWithRC -> ((ResolvedDependencyWithReferenceCount)pkgWithRC).resolvedDependency.equals(resolvedDependency)).findFirst();
        }

        private Optional<ResolvedDependency> retrieve() {
            if (this.validVersions.isEmpty()) {
                return this.evictedVersions.isEmpty() ? Optional.empty() : Optional.of(this.evictedVersions.peek());
            }
            return Optional.of(this.validVersions.peek().resolvedDependency);
        }

        private void decreaseReferenceCount(ResolvedDependency resolvedDependency) {
            Optional<ResolvedDependencyWithReferenceCount> optionalTarget = this.find(resolvedDependency);
            if (optionalTarget.isPresent()) {
                ResolvedDependencyWithReferenceCount target = optionalTarget.get();
                target.referenceCount--;
                LOGGER.debug("Decrease reference count of {} to {}", (Object)target.resolvedDependency, (Object)target.referenceCount);
                if (target.referenceCount == 0) {
                    this.validVersions.remove(target);
                    this.addEvictedDependency(target.resolvedDependency);
                }
            }
        }

        private boolean noValidVersionExists() {
            return this.validVersions.isEmpty();
        }

        private void onlyDecreaseDescendantsReferenceCount() {
            List<ResolvedDependency> allVersionDependencies = this.validVersions.stream().map(rec$ -> ((ResolvedDependencyWithReferenceCount)rec$).getResolvedDependency()).collect(Collectors.toList());
            allVersionDependencies.forEach(x$0 -> DefaultDependencyRegistry.this.decreaseAllDescendantsReferenceCount(x$0));
        }

        private ResolvedDependencyWithReferenceCount headOfValidVersions() {
            return this.validVersions.peek();
        }
    }
}

