/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public abstract class ResolvableGolangPackage
extends GolangPackage {
    private String rootPathString;

    protected ResolvableGolangPackage(Path rootPath, Path path) {
        super(path);
        this.rootPathString = StringUtils.toUnixString(rootPath);
    }

    @Override
    public String getRootPathString() {
        return this.rootPathString;
    }

    @Override
    public Path getRootPath() {
        return Paths.get(this.rootPathString, new String[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ResolvableGolangPackage that = (ResolvableGolangPackage)o;
        return Objects.equals(this.rootPathString, that.rootPathString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rootPathString);
    }
}

