/*
 * Decompiled with CFR 0.152.
 */
package com.github.bjornvester.wsdl2java;

import com.github.bjornvester.wsdl2java.Wsdl2JavaPluginExtension;
import com.github.bjornvester.wsdl2java.Wsdl2JavaTask;
import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/github/bjornvester/wsdl2java/Wsdl2JavaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "sourcesOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getSourcesOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "setSourcesOutputDir", "(Lorg/gradle/api/file/DirectoryProperty;)V", "wsdlFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getWsdlFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "setWsdlFiles", "(Lorg/gradle/api/file/ConfigurableFileCollection;)V", "wsdlInputDir", "getWsdlInputDir", "setWsdlInputDir", "doCodeGeneration", "", "getWsdl2JavaExtension", "Lcom/github/bjornvester/wsdl2java/Wsdl2JavaPluginExtension;", "wsdl2java-gradle-plugin"})
public class Wsdl2JavaTask
extends DefaultTask {
    @NotNull
    private DirectoryProperty wsdlInputDir = this.getWsdl2JavaExtension().getWsdlDir();
    @Optional
    @NotNull
    private ConfigurableFileCollection wsdlFiles = this.getWsdl2JavaExtension().getWsdlFiles();
    @NotNull
    private DirectoryProperty sourcesOutputDir = this.getWsdl2JavaExtension().getGeneratedSourceDir();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final DirectoryProperty getWsdlInputDir() {
        return this.wsdlInputDir;
    }

    public final void setWsdlInputDir(@NotNull DirectoryProperty directoryProperty) {
        Intrinsics.checkParameterIsNotNull((Object)directoryProperty, (String)"<set-?>");
        this.wsdlInputDir = directoryProperty;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getWsdlFiles() {
        return this.wsdlFiles;
    }

    public final void setWsdlFiles(@NotNull ConfigurableFileCollection configurableFileCollection) {
        Intrinsics.checkParameterIsNotNull((Object)configurableFileCollection, (String)"<set-?>");
        this.wsdlFiles = configurableFileCollection;
    }

    @OutputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final DirectoryProperty getSourcesOutputDir() {
        return this.sourcesOutputDir;
    }

    public final void setSourcesOutputDir(@NotNull DirectoryProperty directoryProperty) {
        Intrinsics.checkParameterIsNotNull((Object)directoryProperty, (String)"<set-?>");
        this.sourcesOutputDir = directoryProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void doCodeGeneration() {
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        Iterator iterator;
        this.getProject().delete(new Object[]{this.sourcesOutputDir});
        if (!this.wsdlFiles.isEmpty()) {
            iterator = this.wsdlFiles.iterator();
        } else {
            FileTree fileTree = this.wsdlInputDir.getAsFileTree().matching((Action)doCodeGeneration.computedWsdlFiles.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"wsdlInputDir.asFileTree.\u2026**/*.wsdl\")\n            }");
            Collection collection2 = fileTree.getFiles();
            boolean bl = false;
            if (collection2.isEmpty()) {
                boolean bl2 = false;
                throw (Throwable)new GradleException("Could not find any WSDL files to import");
            }
            iterator = ((Set)collection2).iterator();
        }
        Iterator computedWsdlFiles2 = iterator;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Set dependentFiles = ((Configuration)project.getConfigurations().named("wsdl2java").get()).resolve();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        project2.getLogger().debug("Loading JAR files: " + dependentFiles);
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        Set set = dependentFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"dependentFiles");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            URL uRL = it.toURI().toURL();
            collection.add(uRL);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = uRLArray;
        URL[] uRLArray2 = (URL[])collection;
        Closeable closeable = new URLClassLoader(uRLArray2);
        boolean bl = false;
        object = null;
        try {
            URLClassLoader classLoader = (URLClassLoader)closeable;
            boolean bl3 = false;
            Class<?> wsdlToJavaClass = classLoader.loadClass("org.apache.cxf.tools.wsdlto.WSDLToJava");
            Class<?> toolContextClass = classLoader.loadClass("org.apache.cxf.tools.common.ToolContext");
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                Iterator $this$forEach$iv = computedWsdlFiles2;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                boolean bl4 = false;
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Object element$iv = iterator3.next();
                    File wsdlFile = (File)element$iv;
                    boolean bl5 = false;
                    Project project3 = this.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                    Logger logger = project3.getLogger();
                    StringBuilder stringBuilder = new StringBuilder().append("Importing file ");
                    File file = wsdlFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"wsdlFile");
                    logger.info(stringBuilder.append(file.getAbsolutePath()).toString());
                    String[] stringArray = new String[8];
                    stringArray[0] = "-verbose";
                    stringArray[1] = "-wsdlLocation";
                    Object object2 = this.wsdlInputDir.getAsFile().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"wsdlInputDir.asFile.get()");
                    stringArray[2] = FilesKt.relativeTo((File)wsdlFile, (File)((File)object2)).getPath();
                    stringArray[3] = "-suppress-generated-date";
                    stringArray[4] = "-autoNameResolution";
                    stringArray[5] = "-d";
                    stringArray[6] = this.sourcesOutputDir.get().toString();
                    stringArray[7] = wsdlFile.getPath();
                    String[] args = stringArray;
                    Object toolContext = toolContextClass.newInstance();
                    Object wsdlToJava = wsdlToJavaClass.getConstructor(String[].class).newInstance(new Object[]{args});
                    wsdlToJavaClass.getMethod("run", toolContextClass).invoke(wsdlToJava, toolContext);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    private final Wsdl2JavaPluginExtension getWsdl2JavaExtension() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Object object = project.getExtensions().getByName("wsdl2java");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.github.bjornvester.wsdl2java.Wsdl2JavaPluginExtension");
        }
        return (Wsdl2JavaPluginExtension)object;
    }

    public Wsdl2JavaTask() {
        this.setGroup("build");
        this.setDescription("Generates Java classes from WSDL files.");
        Object[] objectArray = new Object[1];
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        objectArray[0] = project.getConfigurations().named("wsdl2java");
        this.dependsOn(objectArray);
    }
}

