/*
 * Decompiled with CFR 0.152.
 */
package com.delphix.gradle.javaformat.tasks;

import com.delphix.gradle.javaformat.tasks.JavaFormatter;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.googlejavaformat.java.FormatterException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class FormatTask
extends DefaultTask {
    private FileCollection javaFiles;
    private Behavior behavior;
    private final Configuration formatterConfiguration = this.getProject().getConfigurations().getByName("googlejavaformat");

    @InputFiles
    @SkipWhenEmpty
    FileCollection getJavaFiles() {
        return this.javaFiles;
    }

    public void setJavaFiles(FileCollection javaFiles) {
        this.javaFiles = javaFiles;
    }

    @Input
    Behavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Behavior behavior) {
        this.behavior = behavior;
    }

    @InputFiles
    @Classpath
    Configuration getFormatterConfiguration() {
        return this.formatterConfiguration;
    }

    private ImmutableSet<File> getOutOfDateFiles(IncrementalTaskInputs inputs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        inputs.outOfDate(info -> builder.add((Object)info.getFile()));
        return builder.build();
    }

    private ImmutableSet<File> calculateFilesToFormat(IncrementalTaskInputs inputs) {
        ImmutableSet<File> changedFiles = this.getOutOfDateFiles(inputs);
        if (Sets.difference(changedFiles, (Set)this.getJavaFiles().getFiles()).isEmpty()) {
            return changedFiles;
        }
        return ImmutableSet.copyOf((Collection)this.getJavaFiles().getFiles());
    }

    private static String getText(File f) {
        try {
            return Files.asCharSource((File)f, (Charset)Charsets.UTF_8).read();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void setText(String text, File f) {
        try {
            Files.asCharSink((File)f, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)text);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @TaskAction
    public void format(IncrementalTaskInputs inputs) {
        this.getProject().mkdir((Object)this.getProject().getBuildDir());
        ImmutableSet<File> filesToFormat = this.calculateFilesToFormat(inputs);
        ImmutableSet.Builder badFilesBuilder = ImmutableSet.builder();
        filesToFormat.forEach(file -> {
            String formattedText;
            String sourceText = FormatTask.getText(file);
            try {
                formattedText = JavaFormatter.formatSource(sourceText, this.getProject());
            }
            catch (FormatterException e) {
                throw new GradleException("Error formatting code", (Throwable)e);
            }
            if (!sourceText.equals(formattedText)) {
                switch (this.behavior) {
                    case FORMAT: {
                        FormatTask.setText(formattedText, file);
                        break;
                    }
                    case CHECK: {
                        try {
                            badFilesBuilder.add((Object)file.getCanonicalPath());
                            break;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }
            }
        });
        ImmutableSet badFiles = badFilesBuilder.build();
        if (badFiles.size() > 0) {
            throw new GradleException("Some files are not formatted properly, run gradlew formatJava to format them:\n" + Joiner.on((char)'\n').join((Iterable)badFiles));
        }
    }

    public static enum Behavior {
        FORMAT,
        CHECK;

    }
}

