/*
 * Decompiled with CFR 0.152.
 */
package com.delphix.gradle.javaformat;

import com.delphix.gradle.javaformat.JavaFormatBasePlugin;
import com.delphix.gradle.javaformat.tasks.FormatTask;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class JavaFormatPlugin
implements Plugin<Project> {
    private static FormatTask createFormatTask(Project project, SourceSet sourceSet, FormatTask.Behavior behavior) {
        String capitalizedName = sourceSet.getName().substring(0, 1).toUpperCase() + sourceSet.getName().substring(1);
        String taskName = (behavior == FormatTask.Behavior.FORMAT ? "formatJava" : "checkJavaFormat") + capitalizedName;
        return (FormatTask)project.getTasks().create(taskName, FormatTask.class, task -> {
            task.setJavaFiles((FileCollection)sourceSet.getJava());
            task.setBehavior(behavior);
        });
    }

    public void apply(Project project) {
        project.apply(Collections.singletonMap("plugin", JavaFormatBasePlugin.class));
        project.getPluginManager().withPlugin("java", javaPlugin -> {
            Task formatTask = project.task("formatJava");
            Task checkTask = project.task("checkJavaFormat");
            SourceSetContainer sourceSets = (SourceSetContainer)project.getProperties().get("sourceSets");
            sourceSets.forEach(sourceSet -> {
                FormatTask projectFormatTask = JavaFormatPlugin.createFormatTask(project, sourceSet, FormatTask.Behavior.FORMAT);
                formatTask.dependsOn(new Object[]{projectFormatTask});
                FormatTask projectCheckTask = JavaFormatPlugin.createFormatTask(project, sourceSet, FormatTask.Behavior.CHECK);
                checkTask.dependsOn(new Object[]{projectCheckTask});
            });
            project.getTasks().getByName("check").dependsOn(new Object[]{checkTask});
        });
    }
}

