package gov.raptor.gradle.plugins.buildsupport

import org.gradle.api.tasks.TaskAction

/**
 * Task definition to update the version file according to the current release build parameters.
 *
 * @author Proprietary information subject to the terms of a Non-Disclosure Agreement
 * @since 0.3
 */
class UpdateReleaseVersionTask extends AReleaseTask {

    UpdateReleaseVersionTask() {
        group = 'Release'
        description = makeDescription("Update the version file on this project according to the build options")
    }

    @SuppressWarnings("GroovyUnusedDeclaration")
    @TaskAction
    void doUpdateReleaseVersion() {

        validateStageProperties()

        updateReleaseVersion { RaptorVersion version ->
            version.stage = project.ext.finalBuild ? '' : project.ext.rcBuild // Set version according to build params
        }
    }
}
