package gov.raptor.gradle.plugins.buildsupport

import org.gradle.api.tasks.TaskAction

/**
 * Task definition to update the version file by incrementing the patch component and resetting the stage
 * to SNAPSHOT.  This is typically used to progress along a release branch.
 *
 * @author Proprietary information subject to the terms of a Non-Disclosure Agreement
 * @since 0.3
 */
class RollPatchVersionTask extends AReleaseTask {

    RollPatchVersionTask() {
        group = 'Release'
        description = makeDescription("Bump the patch component in the version file on this project (e.g., 2.6.1 -> 2.6.2-SNAPSHOT)", REPO_OPTIONS)
    }

    @SuppressWarnings("GroovyUnusedDeclaration")
    @TaskAction
    void doUpdateVersion() {

        updateReleaseVersion { RaptorVersion version ->
            version.bumpPatch()
            version.setStage('SNAPSHOT')
        }
    }
}
