package gov.raptor.gradle.plugins.buildsupport

import org.gradle.api.tasks.TaskAction

/**
 * Task definition to update the version file by incrementing the patch component and resetting the stage
 * to SNAPSHOT.  This is typically used to progress along a release branch.
 *
 * @author Proprietary information subject to the terms of a Non-Disclosure Agreement
 * @since 0.3
 */
class RollMinorVersionTask extends AReleaseTask {

    RollMinorVersionTask() {
        group = 'Release'
        description = makeDescription("Bump the minor component in the version file on this project (e.g., 2.6.1 -> 2.7.2-SNAPSHOT)", REPO_OPTIONS)
    }

    @SuppressWarnings("GroovyUnusedDeclaration")
    @TaskAction
    void doUpdateVersion() {

        getToRootBranch() // Ensure we are on the dev/master branch

        updateReleaseVersion { RaptorVersion version ->
            version.bumpMinor()
            version.setPatch(1) // Reset the patch to one, avoid 2.6.2 -> 2.7.2 instead of 2.7.1
            version.setStage('SNAPSHOT')
        }
    }
}
