/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.uPnPClient;

import com.github.kilianB.uPnPClient.UPnPDevice;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleDeviceDiscovery {
    public static final String USER_AGENT = "Linux UPnP/1.0 Sonos/42.2-52113 (WDCR:Microsoft Windows NT 10.0.16299)";
    private static final Logger LOGGER = Logger.getLogger(SimpleDeviceDiscovery.class.getName());
    private static final String UPNP_HOST = "239.255.255.250";
    private static final int UPNP_PORT = 1900;
    private static final String DISCOVERY_REQUEST = "M-SEARCH * HTTP/1.1\r\nHOST:  239.255.255.250:1900\r\nMAN: \"ssdp:discover\"\r\nMX: {mx}\r\nST: ssdp:all\r\n\r\n";

    public static List<UPnPDevice> discoverDevices() throws IOException {
        return SimpleDeviceDiscovery.discoverDevices(1, 2, null);
    }

    public static List<UPnPDevice> discoverDevices(String searchTarget) throws IOException {
        return SimpleDeviceDiscovery.discoverDevices(1, 2, searchTarget);
    }

    public static List<UPnPDevice> discoverDevices(int loadBalancingDelay, int timeout, String searchTarget, UPnPDeviceFoundListener callback) throws IOException {
        ArrayList<UPnPDevice> devicesFound = new ArrayList<UPnPDevice>();
        String request = SimpleDeviceDiscovery.prepareRequest(loadBalancingDelay, timeout *= 1000, searchTarget);
        byte[] payload = request.getBytes();
        DatagramPacket discoveryRequest = new DatagramPacket(payload, payload.length, new InetSocketAddress(UPNP_HOST, 1900));
        DatagramSocket udpSocket = new DatagramSocket();
        udpSocket.setSoTimeout(timeout * 1000);
        udpSocket.send(discoveryRequest);
        long startTime = System.currentTimeMillis();
        while (true) {
            int timeLeft;
            byte[] response = new byte[1024];
            DatagramPacket incommingPacket = new DatagramPacket(response, response.length);
            try {
                udpSocket.receive(incommingPacket);
            }
            catch (SocketTimeoutException timeouted) {
                break;
            }
            HashMap<String, String> deviceInfo = SimpleDeviceDiscovery.parseUpnpNotifyAndSearchMessage(new String(incommingPacket.getData()));
            UPnPDevice device = new UPnPDevice(incommingPacket.getAddress(), deviceInfo);
            devicesFound.add(device);
            if (callback != null) {
                new Thread(() -> callback.upnpDeviceFound(device)).start();
            }
            if ((timeLeft = timeout - (int)(System.currentTimeMillis() - startTime)) <= 0) break;
            udpSocket.setSoTimeout(timeLeft);
        }
        udpSocket.close();
        return devicesFound;
    }

    public static List<UPnPDevice> discoverDevices(int loadBalancingDelay, int timeout, String searchTarget) throws IOException {
        return SimpleDeviceDiscovery.discoverDevices(loadBalancingDelay, timeout, searchTarget, null);
    }

    public static UPnPDevice discoverDevice(String searchTarget) throws IOException {
        return SimpleDeviceDiscovery.discoverDevice(1, 2, searchTarget);
    }

    public UPnPDevice discoverDevice(int timeout, String searchTarget) throws IOException {
        return SimpleDeviceDiscovery.discoverDevice(1, timeout, searchTarget);
    }

    public static UPnPDevice discoverDevice(int loadBalancingDelay, int timeout, String searchTarget) throws IOException {
        String request = SimpleDeviceDiscovery.prepareRequest(loadBalancingDelay, timeout *= 1000, searchTarget);
        byte[] payload = request.getBytes();
        DatagramPacket discoveryRequest = new DatagramPacket(payload, payload.length, new InetSocketAddress(UPNP_HOST, 1900));
        DatagramSocket udpSocket = new DatagramSocket();
        udpSocket.setSoTimeout(timeout * 1000);
        udpSocket.send(discoveryRequest);
        byte[] returnValue = new byte[1024];
        try {
            DatagramPacket incommingPacket = new DatagramPacket(returnValue, returnValue.length);
            udpSocket.receive(incommingPacket);
            udpSocket.close();
            return new UPnPDevice(incommingPacket.getAddress(), SimpleDeviceDiscovery.parseUpnpNotifyAndSearchMessage(new String(incommingPacket.getData())));
        }
        catch (SocketTimeoutException timeouted) {
            udpSocket.close();
            return null;
        }
    }

    private static String prepareRequest(int loadBalancingDelay, int timeout, String searchTarget) {
        if (loadBalancingDelay < 1 || loadBalancingDelay > 5) {
            LOGGER.warning("Load balancing delay should be within [1-5] seconds. A default of 1s is assumed");
            loadBalancingDelay = 1;
        }
        if (loadBalancingDelay >= timeout / 1000) {
            LOGGER.warning("Load balancing delay should not be higher or equal than the timeout. This will lead to some devices not being discovered!");
        }
        String request = DISCOVERY_REQUEST;
        if (searchTarget != null && !searchTarget.isEmpty() && !searchTarget.equals("ssdp:all")) {
            request = request.replace("ssdp:all", searchTarget);
        }
        return request.replace("{mx}", Integer.toString(loadBalancingDelay));
    }

    private static HashMap<String, String> parseUpnpNotifyAndSearchMessage(String messageToParse) {
        Matcher matcher = Pattern.compile("(.*?):(.*)").matcher(messageToParse);
        HashMap<String, String> parsedKeyValues = new HashMap<String, String>();
        while (matcher.find()) {
            parsedKeyValues.put(matcher.group(1), matcher.group(2));
        }
        return parsedKeyValues;
    }

    public static interface UPnPDeviceFoundListener {
        public void upnpDeviceFound(UPnPDevice var1);
    }
}

