/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos.model;

import com.github.kilianB.sonos.ParserHelper;
import com.github.kilianB.sonos.model.TrackMetadata;

public class TrackInfo {
    private final int queueIndex;
    private final int duration;
    private final int position;
    private final String uri;
    private final TrackMetadata metadata;

    public TrackInfo(int queueIndex, int duration, int position, String uri, TrackMetadata metadata) {
        this.queueIndex = queueIndex;
        this.duration = duration;
        this.position = position;
        this.uri = uri;
        this.metadata = metadata;
    }

    public int getQueueIndex() {
        return this.queueIndex;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getDurationAsString() {
        return ParserHelper.secondsToFormatedTimestamp(this.duration);
    }

    public int getPosition() {
        return this.position;
    }

    public String getPositionAsString() {
        return ParserHelper.secondsToFormatedTimestamp(this.position);
    }

    public String getUri() {
        return this.uri;
    }

    public TrackMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "TrackInfo{queueIndex=" + this.queueIndex + ", duration='" + this.duration + "', position='" + this.position + "', uri='" + this.uri + "', metadata=" + this.metadata + "}";
    }

    public boolean sameBaseTrack(TrackInfo infoToCompareTo) {
        return this.uri.equals(infoToCompareTo.uri) && this.metadata.equals(infoToCompareTo.metadata);
    }

    public boolean isEmpty() {
        return this.queueIndex == 0 && this.duration == 0 && this.position == 0 && this.uri.isEmpty();
    }
}

