/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos.listener;

import com.github.kilianB.sonos.SonosDevice;
import com.github.kilianB.sonos.listener.SonosEventListener;
import com.github.kilianB.uPnPClient.UPnPEvent;
import com.github.kilianB.uPnPClient.UPnPEventAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdom2.Element;

public class ZoneTopologyListener
extends UPnPEventAdapter {
    private HashSet<String> presentDevices = new HashSet();
    private HashSet<String> groupState = new HashSet();
    private List<SonosEventListener> listeners;
    private SonosDevice device;

    public ZoneTopologyListener(String servicePath, SonosDevice device) {
        this.device = device;
        this.listeners = device.getEventListener();
    }

    @Override
    public void initialEventReceived(UPnPEvent event) {
        this.presentDevices.addAll(this.parseConnectedDeviceNames(event));
    }

    @Override
    public void eventReceived(UPnPEvent event) {
        HashSet<String> currentConnectedDevices = this.parseConnectedDeviceNames(event);
        currentConnectedDevices.stream().forEach(deviceName -> {
            if (!this.presentDevices.contains(deviceName)) {
                for (SonosEventListener listener : this.listeners) {
                    listener.sonosDeviceConnected((String)deviceName);
                }
            }
        });
        if (this.presentDevices.removeAll(currentConnectedDevices)) {
            this.presentDevices.stream().forEach(deviceName -> {
                for (SonosEventListener listener : this.listeners) {
                    listener.sonosDeviceDisconnected((String)deviceName);
                }
            });
        }
        this.presentDevices = currentConnectedDevices;
    }

    private HashSet<String> parseConnectedDeviceNames(UPnPEvent event) {
        String ownName = this.device.getDeviceNameCached();
        HashSet<String> devices = new HashSet<String>();
        for (Element property : event.getProperties()) {
            if (!property.getName().equals("ZoneGroupState")) continue;
            List zoneGroups = property.getChild("ZoneGroups").getChildren("ZoneGroup");
            for (Element zoneGroup : zoneGroups) {
                ArrayList<String> allDevicesInZone = new ArrayList<String>();
                for (Element device : zoneGroup.getChildren("ZoneGroupMember")) {
                    String deviceName = device.getAttributeValue("ZoneName");
                    allDevicesInZone.add(deviceName);
                }
                if (allDevicesInZone.contains(ownName)) {
                    if (!(this.groupState.isEmpty() || this.groupState.containsAll(allDevicesInZone) && this.groupState.size() == allDevicesInZone.size())) {
                        this.groupState.clear();
                        for (SonosEventListener listener : this.listeners) {
                            listener.groupChanged(allDevicesInZone);
                        }
                    }
                    this.groupState.addAll(allDevicesInZone);
                }
                devices.addAll(allDevicesInZone);
            }
        }
        return devices;
    }
}

