/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos.listener;

import com.github.kilianB.sonos.ParserHelper;
import com.github.kilianB.sonos.SonosDevice;
import com.github.kilianB.sonos.listener.SonosEventListener;
import com.github.kilianB.sonos.model.AVTransportEvent;
import com.github.kilianB.sonos.model.PlayMode;
import com.github.kilianB.sonos.model.PlayState;
import com.github.kilianB.sonos.model.TrackInfo;
import com.github.kilianB.sonos.model.TrackMetadata;
import com.github.kilianB.uPnPClient.UPnPEvent;
import com.github.kilianB.uPnPClient.UPnPEventAdapter;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AVTTransportListener
extends UPnPEventAdapter {
    private static final Namespace upnpAVTNamespace = Namespace.getNamespace((String)"urn:schemas-upnp-org:metadata-1-0/AVT/");
    private static final Namespace upnpRinnconnectsNamespace = Namespace.getNamespace((String)"r", (String)"urn:schemas-rinconnetworks-com:metadata-1-0/");
    private final List<SonosEventListener> listeners;
    private TrackInfo currentTrack;
    private PlayMode currentPlayMode;
    private PlayState currentPlayState;

    public AVTTransportListener(String servicePath, SonosDevice device) {
        this.listeners = device.getEventListener();
    }

    @Override
    public void initialEventReceived(UPnPEvent event) {
        Iterator<Element> iterator = event.getProperties().iterator();
        if (iterator.hasNext()) {
            Element e = iterator.next();
            AVTransportEvent avtEvent = this.parseEvent(e);
            this.currentTrack = avtEvent.getCurrentTrack();
            this.currentPlayMode = avtEvent.getCurrentPlayMode();
            this.currentPlayState = avtEvent.getTransportState();
            return;
        }
    }

    @Override
    public void eventReceived(UPnPEvent event) {
        for (Element e : event.getProperties()) {
            AVTransportEvent avtEvent = this.parseEvent(e);
            if (!this.currentTrack.sameBaseTrack(avtEvent.getCurrentTrack())) {
                this.currentTrack = avtEvent.getCurrentTrack();
                for (SonosEventListener listener : this.listeners) {
                    listener.trackChanged(avtEvent.getCurrentTrack());
                }
            }
            if (!this.currentPlayMode.equals((Object)avtEvent.getCurrentPlayMode())) {
                this.currentPlayMode = avtEvent.getCurrentPlayMode();
                for (SonosEventListener listener : this.listeners) {
                    listener.playModeChanged(avtEvent.getCurrentPlayMode());
                }
            }
            if (!this.currentPlayState.equals((Object)avtEvent.getTransportState())) {
                this.currentPlayState = avtEvent.getTransportState();
                for (SonosEventListener listener : this.listeners) {
                    listener.playStateChanged(avtEvent.getTransportState());
                }
            }
            for (SonosEventListener listener : this.listeners) {
                listener.avtTransportEvent(avtEvent);
            }
        }
    }

    private AVTransportEvent parseEvent(Element e) {
        int trackDurationInSeconds;
        Element avtEvent = ParserHelper.unwrapSonosEvent(e, upnpAVTNamespace);
        PlayState transportState = PlayState.valueOf(ParserHelper.extractEventValue(avtEvent, "TransportState", upnpAVTNamespace));
        PlayMode currentPlayModeInfo = PlayMode.valueOf(ParserHelper.extractEventValue(avtEvent, "CurrentPlayMode", upnpAVTNamespace));
        boolean crossFade = Integer.parseInt(ParserHelper.extractEventValue(avtEvent, "CurrentCrossfadeMode", upnpAVTNamespace)) != 0;
        int numberOfTracks = Integer.parseInt(ParserHelper.extractEventValue(avtEvent, "NumberOfTracks", upnpAVTNamespace));
        int currentTrackNumber = Integer.parseInt(ParserHelper.extractEventValue(avtEvent, "CurrentTrack", upnpAVTNamespace));
        int currentSection = Integer.parseInt(ParserHelper.extractEventValue(avtEvent, "CurrentSection", upnpAVTNamespace));
        String currentTrackURI = StringEscapeUtils.unescapeXml((String)ParserHelper.extractEventValue(avtEvent, "CurrentTrackURI", upnpAVTNamespace));
        String currentTrackDurationRaw = ParserHelper.extractEventValue(avtEvent, "CurrentTrackDuration", upnpAVTNamespace);
        try {
            trackDurationInSeconds = ParserHelper.formatedTimestampToSeconds(currentTrackDurationRaw);
        }
        catch (NumberFormatException nfe) {
            trackDurationInSeconds = 0;
        }
        TrackMetadata trackMeta = TrackMetadata.parse(StringEscapeUtils.unescapeXml((String)ParserHelper.extractEventValue(avtEvent, "CurrentTrackMetaData", upnpAVTNamespace)));
        String nextTrackURI = StringEscapeUtils.unescapeXml((String)ParserHelper.extractEventValue(avtEvent, "NextTrackURI", upnpRinnconnectsNamespace));
        TrackMetadata nextTrackMetaData = TrackMetadata.parse(StringEscapeUtils.unescapeXml((String)ParserHelper.extractEventValue(avtEvent, "NextTrackMetaData", upnpRinnconnectsNamespace)));
        TrackInfo currentTrackInfo = new TrackInfo(currentTrackNumber, trackDurationInSeconds, -1, currentTrackURI, trackMeta);
        TrackInfo nextTrack = new TrackInfo(currentTrackNumber + 1, -1, -1, nextTrackURI, nextTrackMetaData);
        String enqueuedTransportURI = StringEscapeUtils.unescapeXml((String)ParserHelper.extractEventValue(avtEvent, "EnqueuedTransportURI", upnpRinnconnectsNamespace));
        TrackMetadata enqueuedTransportURIMetaData = TrackMetadata.parse(StringEscapeUtils.unescapeXml((String)ParserHelper.extractEventValue(avtEvent, "EnqueuedTransportURIMetaData", upnpRinnconnectsNamespace)));
        return new AVTransportEvent(transportState, currentPlayModeInfo, crossFade, numberOfTracks, currentSection, currentTrackInfo, nextTrack, enqueuedTransportURI, enqueuedTransportURIMetaData);
    }
}

