/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.xhtml.internal.styles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.xwpf.converter.xhtml.internal.styles.CSSProperty;
import org.apache.poi.xwpf.converter.xhtml.internal.utils.SAXHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyle {
    private final String tagName;
    private final String className;
    private List<CSSProperty> properties;

    public CSSStyle(String tagName, String className) {
        this.tagName = tagName;
        this.className = className;
        this.properties = null;
    }

    public void save(ContentHandler contentHandler) throws SAXException {
        StringBuilder style = new StringBuilder(this.tagName);
        if (this.className != null) {
            style.append('.');
            style.append(this.className);
        }
        style.append('{');
        this.buildInlineStyles(style);
        style.append('}');
        SAXHelper.characters(contentHandler, style.toString());
    }

    public String getInlineStyles() {
        if (this.properties == null) {
            return "";
        }
        StringBuilder styles = new StringBuilder();
        this.buildInlineStyles(styles);
        return styles.toString();
    }

    public void buildInlineStyles(StringBuilder style) {
        List<CSSProperty> properties = this.getProperties();
        for (CSSProperty property : properties) {
            style.append(property.getName());
            style.append(':');
            style.append(property.getValue());
            style.append(';');
        }
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<CSSProperty>();
        }
        this.properties.add(new CSSProperty(name, value));
    }

    public List<CSSProperty> getProperties() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        return this.properties;
    }

    public boolean isEmpty() {
        return this.properties != null && this.properties.size() > 0;
    }
}

