/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension;

import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;

public class ExtendedPdfPTable
extends PdfPTable
implements IITextContainer {
    private IITextContainer container;
    private boolean empty;
    private PdfPCell wrapperCell;
    private PdfPTable wrapperTable;

    public ExtendedPdfPTable(int numColumns) {
        super(numColumns);
        super.setSpacingBefore(0.0f);
        this.empty = true;
        super.setLockedWidth(true);
        super.setHorizontalAlignment(0);
    }

    public void addElement(Element element) {
        if (element instanceof PdfPCell) {
            this.addCell((PdfPCell)element);
        }
    }

    public IITextContainer getITextContainer() {
        return this.container;
    }

    public void setITextContainer(IITextContainer container) {
        this.container = container;
    }

    public float getRowHeight(int idx) {
        return this.getRowHeight(idx, false);
    }

    public float getRowHeight(int idx, boolean firsttime) {
        if (this.totalWidth <= 0.0f || idx < 0 || idx >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow row = (PdfPRow)this.rows.get(idx);
        if (row == null) {
            return 0.0f;
        }
        if (firsttime) {
            row.setWidths(this.absoluteWidths);
        }
        float height = row.getMaxHeights();
        for (int i = 0; i < this.relativeWidths.length; ++i) {
            if (!this.rowSpanAbove(idx, i)) continue;
            int rs = 1;
            while (this.rowSpanAbove(idx - rs, i)) {
                ++rs;
            }
            PdfPRow tmprow = (PdfPRow)this.rows.get(idx - rs);
            PdfPCell cell = tmprow.getCells()[i];
            float tmp = 0.0f;
            if (cell == null) {
                tmprow.getCells()[i] = cell = new PdfPCell();
            }
            if (cell.getRowspan() == rs + 1) {
                tmp = cell.getMaxHeight();
                while (rs > 0) {
                    tmp -= this.getRowHeight(idx - rs);
                    --rs;
                }
            }
            if (!(tmp > height)) continue;
            height = tmp;
        }
        row.setMaxHeights(height);
        return height;
    }

    boolean rowSpanAbove(int currRow, int currCol) {
        if (currCol >= this.getNumberOfColumns() || currCol < 0 || currRow == 0) {
            return false;
        }
        int row = currRow - 1;
        PdfPRow aboveRow = (PdfPRow)this.rows.get(row);
        if (aboveRow == null) {
            return false;
        }
        PdfPCell aboveCell = aboveRow.getCells()[currCol];
        while (aboveCell == null && row > 0) {
            if ((aboveRow = (PdfPRow)this.rows.get(--row)) == null) {
                return false;
            }
            aboveCell = aboveRow.getCells()[currCol];
        }
        int distance = currRow - row;
        if (aboveCell == null) {
            int col = currCol - 1;
            aboveCell = aboveRow.getCells()[col];
            while (aboveCell == null && row > 0) {
                aboveCell = aboveRow.getCells()[--col];
            }
            return aboveCell != null && aboveCell.getRowspan() > distance;
        }
        if (aboveCell.getRowspan() == 1 && distance > 1) {
            int col = currCol - 1;
            aboveRow = (PdfPRow)this.rows.get(row + 1);
            --distance;
            aboveCell = aboveRow.getCells()[col];
            while (aboveCell == null && col > 0) {
                aboveCell = aboveRow.getCells()[--col];
            }
        }
        return aboveCell != null && aboveCell.getRowspan() > distance;
    }

    public void addCell(Image image) {
        this.empty = false;
        super.addCell(image);
    }

    public void addCell(PdfPCell cell) {
        this.empty = false;
        super.addCell(cell);
    }

    public void addCell(PdfPTable table) {
        this.empty = false;
        super.addCell(table);
    }

    public void addCell(Phrase phrase) {
        this.empty = false;
        super.addCell(phrase);
    }

    public void addCell(String text) {
        this.empty = false;
        super.addCell(text);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setPadding(float padding) {
        this.getWrapperCell().setPadding(padding);
    }

    public void setPaddingLeft(float paddingLeft) {
        this.getWrapperCell().setPaddingLeft(paddingLeft);
    }

    public void setPaddingRight(float paddingRight) {
        this.getWrapperCell().setPaddingRight(paddingRight);
    }

    public void setPaddingBottom(float paddingBottom) {
        this.getWrapperCell().setPaddingBottom(paddingBottom);
    }

    public void setPaddingTop(float paddingTop) {
        this.getWrapperCell().setPaddingTop(paddingTop);
    }

    private PdfPCell createCell() {
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPadding(0.0f);
        cell.setUseBorderPadding(true);
        return cell;
    }

    private PdfPTable createTable(PdfPCell cell) {
        PdfPTable table = new PdfPTable(1);
        table.setSpacingBefore(this.spacingBefore());
        table.setSpacingAfter(this.spacingAfter());
        table.setHorizontalAlignment(this.getHorizontalAlignment());
        table.setTotalWidth(cell.getPaddingLeft() + this.getTotalWidth() + cell.getPaddingRight());
        table.setLockedWidth(true);
        table.setSplitLate(false);
        table.addCell(cell);
        return table;
    }

    private PdfPCell getWrapperCell() {
        if (this.wrapperCell == null) {
            this.wrapperCell = this.createCell();
        }
        return this.wrapperCell;
    }

    public Element getElement() {
        if (this.wrapperTable != null) {
            return this.wrapperTable;
        }
        if (this.wrapperCell != null) {
            this.wrapperCell.addElement((Element)this);
            this.wrapperTable = this.createTable(this.wrapperCell);
            return this.wrapperTable;
        }
        return this;
    }
}

