/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension.font;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import java.awt.Color;

public abstract class AbstractFontRegistry
implements IFontProvider {
    private boolean systemEncodingDeterminated;
    private String systemEncoding;
    private static boolean registerFontDirectories = false;

    @Override
    public Font getFont(String familyName, String encoding, float size, int style, Color color) {
        this.registerFontDirectoriesIfNeeded();
        if (familyName != null) {
            familyName = this.resolveFamilyName(familyName, style);
        }
        return FontFactory.getFont((String)familyName, (String)encoding, (float)size, (int)style, (Color)color);
    }

    private void registerFontDirectoriesIfNeeded() {
        if (!registerFontDirectories) {
            FontFactory.registerDirectories();
            registerFontDirectories = true;
        }
    }

    public boolean isBold(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 1) == 1;
    }

    public boolean isItalic(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 2) == 2;
    }

    public boolean isUnderlined(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 4) == 4;
    }

    public boolean isStrikethru(int style) {
        if (style == -1) {
            return false;
        }
        return (style & 8) == 8;
    }

    public String getSystemEncoding() {
        if (this.systemEncodingDeterminated) {
            return this.systemEncoding;
        }
        this.systemEncoding = System.getProperty("sun.jnu.encoding");
        if (this.systemEncoding != null && this.systemEncoding.length() > 0) {
            this.systemEncodingDeterminated = true;
            return this.systemEncoding;
        }
        this.systemEncoding = System.getProperty("ibm.system.encoding");
        if (this.systemEncoding != null && this.systemEncoding.length() > 0) {
            this.systemEncodingDeterminated = true;
            return this.systemEncoding;
        }
        this.systemEncoding = FontFactory.defaultEncoding;
        this.systemEncodingDeterminated = true;
        return this.systemEncoding;
    }

    protected abstract String resolveFamilyName(String var1, int var2);
}

