/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.LocalDate;
import java.time.temporal.ValueRange;
import java.util.Objects;

public final class YearRangeHoliday
implements Holiday {
    private final Holiday base;
    private final ValueRange validityRange;

    public YearRangeHoliday(Holiday base, ValueRange validityRange) {
        this.base = Objects.requireNonNull(base);
        this.validityRange = Objects.requireNonNull(validityRange);
    }

    public YearRangeHoliday(Holiday base, long from, long to) {
        this.base = Objects.requireNonNull(base);
        this.validityRange = ValueRange.of(from, to);
    }

    @Override
    public boolean check(LocalDate date) {
        if (!this.validityRange.isValidValue(date.getYear())) {
            return false;
        }
        return this.base.check(date);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YearRangeHoliday that = (YearRangeHoliday)o;
        return this.base.equals(that.base) && this.validityRange.equals(that.validityRange);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.validityRange);
    }

    public String toString() {
        return "YearRangeHoliday{base=" + this.base + ", validityRange=" + this.validityRange + '}';
    }
}

