/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class SuppressedHoliday
implements Holiday {
    private final Holiday base;
    private final Set<Integer> suppressedYears;

    public SuppressedHoliday(Holiday base, Collection<Integer> suppressedYears) {
        this.base = Objects.requireNonNull(base);
        this.suppressedYears = new HashSet<Integer>(suppressedYears);
    }

    public SuppressedHoliday(Holiday base, Integer ... suppressedYears) {
        this(base, Arrays.asList(suppressedYears));
    }

    @Override
    public boolean check(LocalDate date) {
        if (this.suppressedYears.contains(date.getYear())) {
            return false;
        }
        return this.base.check(date);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuppressedHoliday that = (SuppressedHoliday)o;
        return this.base.equals(that.base) && this.suppressedYears.equals(that.suppressedYears);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.suppressedYears);
    }

    public String toString() {
        return "SuppressedHoliday{base=" + this.base + ", suppressedYears=" + this.suppressedYears + '}';
    }
}

