/*
 * Decompiled with CFR 0.152.
 */
package fr.marcwrobel.jbanking.calendar;

import fr.marcwrobel.jbanking.calendar.Calendar;
import fr.marcwrobel.jbanking.calendar.Holiday;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class ConfigurableCalendar
implements Calendar {
    private final Set<Holiday> holidays;

    public ConfigurableCalendar(Collection<Holiday> holidays) {
        HashSet<Holiday> copy = new HashSet<Holiday>(holidays.size());
        for (Holiday holiday : holidays) {
            copy.add(Objects.requireNonNull(holiday));
        }
        this.holidays = Collections.unmodifiableSet(copy);
    }

    public ConfigurableCalendar(Holiday ... holidays) {
        this(Arrays.asList(holidays));
    }

    @Override
    public boolean isHoliday(LocalDate date) {
        for (Holiday holiday : this.holidays) {
            if (!holiday.check(date)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Holiday> getHolidaysFor(LocalDate date) {
        HashSet<Holiday> matchingHolidays = new HashSet<Holiday>(0);
        for (Holiday holiday : this.holidays) {
            if (!holiday.check(date)) continue;
            matchingHolidays.add(holiday);
        }
        return Collections.unmodifiableSet(matchingHolidays);
    }
}

